/*
 * Decompiled with CFR 0.152.
 */
package net.jnellis.binpack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jnellis.binpack.LinearBin;
import net.jnellis.binpack.LinearBinPacker;

public class SpliceableBinPacker
extends LinearBinPacker {
    @Override
    public List<LinearBin> packAll(List<Double> pieces, List<LinearBin> existingBins, List<Double> availableCapacities) {
        return super.packAll(SpliceableBinPacker.createSplicePieces(pieces, Collections.max(availableCapacities)), existingBins, availableCapacities);
    }

    public static List<Double> createSplicePieces(Iterable<Double> pieces, Double maxCapacity) {
        ArrayList<Double> newPieces = new ArrayList<Double>();
        for (Double piece : pieces) {
            while (piece > maxCapacity) {
                piece = piece - maxCapacity;
                newPieces.add(maxCapacity);
            }
            if (!(piece > 0.0)) continue;
            newPieces.add(piece);
        }
        return newPieces;
    }
}

