/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.resource;

import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.model.ContainerType;
import org.ligoj.app.plugin.id.dao.ContainerScopeRepository;
import org.ligoj.app.plugin.id.model.ContainerScope;
import org.ligoj.bootstrap.core.json.PaginationJson;
import org.ligoj.bootstrap.core.json.TableItem;
import org.ligoj.bootstrap.core.json.datatable.DataTableAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Path(value="/service/id/container-scope")
@Service
@Produces(value={"application/json"})
@Transactional
public class ContainerScopeResource {
    @Autowired
    private ContainerScopeRepository repository;
    @Autowired
    private PaginationJson paginationJson;
    private static final Map<String, String> ORDERED_COLUMNS = new HashMap<String, String>();

    @CacheResult(cacheName="container-scopes")
    public List<ContainerScope> findAllDescOrder(@CacheKey ContainerType type) {
        return this.repository.findAllOrderByDnDesc(type);
    }

    @GET
    @Path(value="{type}")
    public TableItem<ContainerScope> findAll(@PathParam(value="type") ContainerType type, @Context UriInfo uriInfo) {
        String criteria = StringUtils.trimToEmpty((String)DataTableAttributes.getSearch((UriInfo)uriInfo));
        Page<ContainerScope> findAll = this.repository.findAll(type, criteria, (Pageable)this.paginationJson.getPageRequest(uriInfo, ORDERED_COLUMNS));
        return this.paginationJson.applyPagination(uriInfo, findAll, Function.identity());
    }

    @PUT
    @Consumes(value={"application/json"})
    @CacheRemoveAll(cacheName="container-scopes")
    public void update(ContainerScope bean) {
        this.repository.saveAndFlush((Object)this.check(bean));
    }

    @POST
    @CacheRemoveAll(cacheName="container-scopes")
    @Consumes(value={"application/json"})
    public int create(ContainerScope bean) {
        return (Integer)((ContainerScope)((Object)this.repository.saveAndFlush((Object)this.check(bean)))).getId();
    }

    protected ContainerScope check(ContainerScope entity) {
        entity.setDn(StringUtils.trimToNull((String)entity.getDn()));
        entity.setName(StringUtils.trimToNull((String)entity.getName()));
        return entity;
    }

    @GET
    @Path(value="{id:\\d+}")
    public ContainerScope findById(@PathParam(value="id") int id) {
        return (ContainerScope)((Object)this.repository.findOneExpected(Integer.valueOf(id)));
    }

    @GET
    @Path(value="name/{name}/{type}")
    public ContainerScope findByName(@PathParam(value="type") ContainerType type, @PathParam(value="name") String name) {
        return (ContainerScope)((Object)this.repository.findAllBy("type", type, new String[]{"name"}, new Object[]{name}).stream().findFirst().orElseThrow(() -> new EntityNotFoundException(name)));
    }

    @GET
    @Path(value="name/{name}")
    public ContainerScope findByName(@PathParam(value="name") String name) {
        return (ContainerScope)((Object)this.repository.findByNameExpected(name));
    }

    @DELETE
    @Path(value="{id}")
    @CacheRemoveAll(cacheName="container-scopes")
    public void delete(@PathParam(value="id") int id) {
        this.repository.delete(id);
    }

    static {
        ORDERED_COLUMNS.put("name", "name");
        ORDERED_COLUMNS.put("dn", "dn");
        ORDERED_COLUMNS.put("locked", "locked");
    }
}

