/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.plugin.id.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.ContainerOrg;
import org.ligoj.app.iam.GroupOrg;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.app.iam.dao.DelegateOrgRepository;
import org.ligoj.app.iam.model.AbstractDelegate;
import org.ligoj.app.iam.model.CacheCompany;
import org.ligoj.app.iam.model.CacheContainer;
import org.ligoj.app.iam.model.CacheGroup;
import org.ligoj.app.iam.model.CacheMembership;
import org.ligoj.app.iam.model.CacheUser;
import org.ligoj.app.iam.model.DelegateOrg;
import org.ligoj.app.iam.model.DelegateType;
import org.ligoj.app.iam.model.ReceiverType;
import org.ligoj.app.model.CacheProjectGroup;
import org.ligoj.app.model.Project;
import org.ligoj.app.plugin.id.dao.CacheProjectGroupRepository;
import org.ligoj.app.plugin.id.dao.IdCacheDao;
import org.ligoj.bootstrap.core.DescribedBean;
import org.ligoj.bootstrap.core.IDescribableBean;
import org.ligoj.bootstrap.core.model.AbstractBusinessEntity;
import org.ligoj.bootstrap.core.model.AbstractNamedAuditedEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Persistable;
import org.springframework.stereotype.Repository;

@Transactional
@Repository
public class IdCacheDaoImpl
implements IdCacheDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdCacheDaoImpl.class);
    @PersistenceContext(type=PersistenceContextType.TRANSACTION, unitName="pu")
    private EntityManager em;
    @Autowired
    private CacheProjectGroupRepository cacheProjectGroupRepository;
    @Autowired
    private DelegateOrgRepository delegateOrgRepository;
    private long cacheRefreshTime = 0L;

    @Override
    public void addGroupToGroup(GroupOrg subGroup, GroupOrg group) {
        this.addGroupToGroupInternal((CacheGroup)this.em.find(CacheGroup.class, (Object)subGroup.getId()), group);
    }

    private void addGroupToGroupInternal(CacheGroup entity, GroupOrg group) {
        this.updateGroupToGroupInternal(entity, (CacheGroup)this.em.find(CacheGroup.class, (Object)group.getId()), Collections.emptySet());
    }

    @Override
    public void addUserToGroup(UserOrg user, GroupOrg group) {
        this.updateUserToGroupInternal((CacheUser)this.em.find(CacheUser.class, (Object)user.getId()), (CacheGroup)this.em.find(CacheGroup.class, (Object)group.getId()), Collections.emptySet());
    }

    private void updateUserToGroupInternal(CacheUser entity, CacheGroup group, Set<String> cacheGroups) {
        if (!cacheGroups.contains(group.getId())) {
            CacheMembership membership = new CacheMembership();
            membership.setUser(entity);
            membership.setGroup(group);
            this.em.persist((Object)membership);
        }
    }

    private void updateGroupToGroupInternal(CacheGroup subGroup, CacheGroup group, Set<String> cacheSubGroups) {
        if (!cacheSubGroups.contains(subGroup.getId())) {
            CacheMembership membership = new CacheMembership();
            membership.setSubGroup(subGroup);
            membership.setGroup(group);
            this.em.persist((Object)membership);
        }
    }

    @Override
    public CacheCompany create(CompanyOrg company, Map<String, CacheCompany> entities) {
        return this.createInternal(company, entities);
    }

    @Override
    public CacheCompany create(CompanyOrg company) {
        return this.createInternal(company, Collections.emptyMap());
    }

    @Override
    public CacheGroup create(GroupOrg group, Map<String, CacheGroup> entities) {
        return this.createInternal(group, entities);
    }

    @Override
    public void create(UserOrg user) {
        CacheUser entity = this.toCacheUser(user);
        entity.setCompany((CacheCompany)Optional.ofNullable(user.getCompany()).map(c -> {
            CacheCompany company = new CacheCompany();
            company.setId((Serializable)((Object)c));
            return company;
        }).orElse(null));
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.clear();
    }

    private CacheCompany createInternal(CompanyOrg company, Map<String, CacheCompany> entities) {
        CacheCompany entity;
        if (entities.containsKey(company.getId())) {
            entity = this.toCacheCompany(company, entities.get(company.getId()));
            this.em.merge((Object)entity);
        } else {
            entity = this.toCacheCompany(company, new CacheCompany());
            this.em.persist((Object)entity);
        }
        return entity;
    }

    private CacheGroup createInternal(GroupOrg group, Map<String, CacheGroup> entities) {
        CacheGroup entity;
        if (entities.containsKey(group.getId())) {
            entity = this.toCacheGroup(group, entities.get(group.getId()));
            this.em.merge((Object)entity);
        } else {
            entity = this.toCacheGroup(group, new CacheGroup());
            this.em.persist((Object)entity);
        }
        return entity;
    }

    private CacheUser createInternal(UserOrg user, Map<String, CacheUser> entities, Map<String, CacheCompany> companies) {
        CacheUser entity;
        if (entities.containsKey(user.getId())) {
            entity = this.toCacheUserInternal(user, entities.get(user.getId()), companies);
            this.em.merge((Object)entity);
        } else {
            entity = this.toCacheUserInternal(user, new CacheUser(), companies);
            this.em.persist((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(CompanyOrg company) {
        this.removeAll(this.em.createQuery("FROM CacheCompany WHERE id=:id").setParameter("id", (Object)company.getId()));
    }

    @Override
    public void delete(GroupOrg group) {
        this.removeAll(this.em.createQuery("FROM CacheMembership WHERE group.id=:id OR subGroup.id=:id").setParameter("id", (Object)group.getId()), this.em.createQuery("FROM CacheProjectGroup WHERE group.id=:id").setParameter("id", (Object)group.getId()), this.em.createQuery("FROM CacheGroup WHERE id=:id").setParameter("id", (Object)group.getId()));
    }

    private void removeAll(Query ... queries) {
        Stream.of(queries).map(Query::getResultList).forEach(l -> l.forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0)));
        this.em.flush();
    }

    @Override
    public void delete(UserOrg user) {
        this.removeAll(this.em.createQuery("FROM CacheMembership WHERE user.id=:id").setParameter("id", (Object)user.getId()), this.em.createQuery("FROM CacheUser WHERE id=:id").setParameter("id", (Object)user.getId()));
    }

    @Override
    public void empty(GroupOrg group) {
        this.removeAll(this.em.createQuery("FROM CacheMembership WHERE group.id=:id").setParameter("id", (Object)group.getId()));
    }

    private <T extends CacheContainer> T fillCacheContainer(ContainerOrg container, T entity) {
        DescribedBean.copy((IDescribableBean)container, entity);
        return entity;
    }

    private int persistUsersAndMemberships(Map<String, UserOrg> users, Map<String, GroupOrg> groups, Map<String, CacheGroup> cacheGroups, Map<String, CacheCompany> cacheCompanies) {
        Map<String, CacheUser> cacheUsers = this.em.createQuery("FROM CacheUser", CacheUser.class).getResultList().stream().collect(Collectors.toMap(AbstractBusinessEntity::getId, Function.identity()));
        List userMemberships = this.em.createQuery("FROM CacheMembership WHERE user is not null", CacheMembership.class).getResultList();
        List groupMemberships = this.em.createQuery("FROM CacheMembership WHERE subGroup is not null", CacheMembership.class).getResultList();
        groupMemberships.stream().collect(Collectors.groupingBy(c -> (String)((Object)c.getSubGroup().getId()) + "-" + String.valueOf(c.getGroup()))).values().stream().filter(l -> l.size() > 1).forEach(l -> l.stream().skip(1L).forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0)));
        userMemberships.stream().collect(Collectors.groupingBy(c -> (String)((Object)c.getUser().getId()) + "-" + String.valueOf(c.getGroup()))).values().stream().filter(l -> l.size() > 1).forEach(l -> l.stream().skip(1L).forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0)));
        Map membershipsByUser = userMemberships.stream().collect(Collectors.groupingBy(c -> (String)((Object)c.getUser().getId()), Collectors.mapping(c -> (String)((Object)c.getGroup().getId()), Collectors.toSet())));
        Map membershipsByGroup = groupMemberships.stream().collect(Collectors.groupingBy(c -> (String)((Object)c.getGroup().getId()), Collectors.mapping(c -> (String)((Object)c.getSubGroup().getId()), Collectors.toSet())));
        int memberships = 0;
        for (UserOrg user : users.values()) {
            CacheUser entity = this.createInternal(user, cacheUsers, cacheCompanies);
            Set<String> cacheUserGroups = membershipsByUser.getOrDefault(user.getId(), Collections.emptySet());
            for (String group : user.getGroups()) {
                this.updateUserToGroupInternal(entity, cacheGroups.get(group), cacheUserGroups);
            }
            memberships += user.getGroups().size();
            cacheUserGroups.removeAll(user.getGroups());
            cacheUserGroups.forEach(g -> {
                log.info("Deleting removed cache entry {}#{}-{} (user/group)", new Object[]{CacheMembership.class.getSimpleName(), user.getId(), g});
                this.em.createQuery("DELETE FROM CacheMembership WHERE user.id=:user and group.id=:group").setParameter("user", (Object)user.getId()).setParameter("group", g).executeUpdate();
            });
        }
        for (GroupOrg group : groups.values()) {
            CacheGroup cachedGroup = cacheGroups.get(group.getId());
            Set<String> cacheSubGroups = membershipsByGroup.getOrDefault(group.getId(), Collections.emptySet());
            for (String subGroup : group.getSubGroups()) {
                this.updateGroupToGroupInternal(cacheGroups.get(subGroup), cachedGroup, cacheSubGroups);
            }
            memberships += group.getSubGroups().size();
            cacheSubGroups.removeAll(group.getSubGroups());
            cacheSubGroups.forEach(g -> {
                log.info("Deleting removed cache entry {}#{}-{} (sub/group)", new Object[]{CacheMembership.class.getSimpleName(), g, group.getId()});
                this.em.createQuery("DELETE FROM CacheMembership WHERE subGroup.id=:subGroup and group.id=:group").setParameter("subGroup", g).setParameter("group", (Object)group.getId()).executeUpdate();
            });
        }
        this.deleteOldCacheEntities(CacheUser.class, cacheUsers, users, ids -> this.deleteBatch(CacheMembership.class, (List<String>)ids, sIds -> this.em.createQuery("DELETE FROM CacheMembership WHERE user.id in (:ids)").setParameter("ids", sIds).executeUpdate()));
        return memberships;
    }

    private int persistProjectGroups(Map<String, CacheGroup> groups) {
        List cachedProjectGroups = this.em.createQuery("FROM CacheProjectGroup WHERE group is not null", CacheProjectGroup.class).getResultList();
        cachedProjectGroups.stream().collect(Collectors.groupingBy(c -> String.valueOf(c.getProject().getId()) + "-" + String.valueOf(c.getGroup()))).values().stream().filter(l -> l.size() > 1).forEach(l -> l.stream().skip(1L).forEach(arg_0 -> ((EntityManager)this.em).remove(arg_0)));
        Map cachedProjectGroupsByProject = cachedProjectGroups.stream().collect(Collectors.groupingBy(c -> (Integer)c.getProject().getId(), Collectors.mapping(c -> (String)((Object)c.getGroup().getId()), Collectors.toSet())));
        Map allProjectGroups = this.cacheProjectGroupRepository.findAllProjectGroup().stream().collect(Collectors.groupingBy(pg -> (Integer)pg[0], Collectors.mapping(pg -> (String)pg[1], Collectors.toSet())));
        for (Map.Entry projectGroups : allProjectGroups.entrySet()) {
            Integer projectId = projectGroups.getKey();
            Set groupIds = projectGroups.getValue();
            Set cachedProjectGroupIds = cachedProjectGroupsByProject.get(projectId);
            for (String groupId : groupIds) {
                if ((cachedProjectGroupIds == null || !cachedProjectGroupIds.contains(groupId)) && groups.containsKey(groupId)) {
                    Project project2 = new Project();
                    project2.setId((Serializable)projectId);
                    CacheProjectGroup entity = new CacheProjectGroup();
                    entity.setProject(project2);
                    entity.setGroup(groups.get(groupId));
                    this.em.persist((Object)entity);
                    continue;
                }
                if (cachedProjectGroupIds == null) continue;
                cachedProjectGroupIds.remove(groupId);
            }
        }
        cachedProjectGroupsByProject.keySet().forEach(project -> ((Set)cachedProjectGroupsByProject.get(project)).forEach(group -> {
            log.info("Deleting removed cache entry {}#{}-{}", new Object[]{CacheProjectGroup.class.getSimpleName(), project, group});
            this.em.createQuery("DELETE FROM CacheProjectGroup WHERE project.id=:project and group.id=:group").setParameter("project", project).setParameter("group", group).executeUpdate();
        }));
        return allProjectGroups.size();
    }

    @Override
    public void removeGroupFromGroup(GroupOrg subGroup, GroupOrg group) {
        this.removeAll(this.em.createQuery("FROM CacheMembership WHERE subGroup.id=:subGroup AND group.id=:group").setParameter("group", (Object)group.getId()).setParameter("subGroup", (Object)subGroup.getId()));
    }

    @Override
    public void removeUserFromGroup(UserOrg user, GroupOrg group) {
        this.removeAll(this.em.createQuery("FROM CacheMembership WHERE user.id=:user AND group.id=:group").setParameter("group", (Object)group.getId()).setParameter("user", (Object)user.getId()));
    }

    private void deleteBatch(Class<?> cls, List<String> ids, Consumer<List<String>> batchConsumer) {
        log.info("Deleting removed cache {} {} entries", (Object)cls.getSimpleName(), (Object)ids.size());
        ListUtils.partition(ids, (int)1000).forEach(batchConsumer);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void reset(Map<String, CompanyOrg> companies, Map<String, GroupOrg> groups, Map<String, UserOrg> users) {
        long start = System.currentTimeMillis();
        log.info("Updating cache entries: {} groups, {} companies, {} users", new Object[]{groups.size(), companies.size(), users.size()});
        this.em.flush();
        this.em.clear();
        Map oldCompanies = this.em.createQuery("FROM CacheCompany", CacheCompany.class).getResultList().stream().collect(Collectors.toMap(AbstractBusinessEntity::getId, Function.identity()));
        Map<String, CacheCompany> cacheCompanies = companies.values().stream().map(c -> this.create((CompanyOrg)c, oldCompanies)).collect(Collectors.toMap(AbstractBusinessEntity::getId, Function.identity()));
        this.em.flush();
        Map oldGroups = this.em.createQuery("FROM CacheGroup", CacheGroup.class).getResultList().stream().collect(Collectors.toMap(AbstractBusinessEntity::getId, Function.identity()));
        Map<String, CacheGroup> cacheGroups = groups.values().stream().map(c -> this.create((GroupOrg)c, oldGroups)).collect(Collectors.toMap(AbstractBusinessEntity::getId, Function.identity()));
        this.em.flush();
        int memberships = this.persistUsersAndMemberships(users, groups, cacheGroups, cacheCompanies);
        this.em.flush();
        int subscribedProjects = this.persistProjectGroups(cacheGroups);
        this.em.flush();
        long updatedDelegate = this.updateDelegateDn(cacheGroups, cacheCompanies);
        this.em.flush();
        this.deleteOldCacheEntities(CacheGroup.class, oldGroups, groups, ids -> this.deleteBatch(CacheProjectGroup.class, (List<String>)ids, sIds -> {
            this.em.createQuery("DELETE FROM CacheMembership WHERE group.id in (:ids) OR subGroup.id in (:ids)").setParameter("ids", sIds).executeUpdate();
            this.em.createQuery("DELETE FROM CacheProjectGroup WHERE group.id in (:ids)").setParameter("ids", sIds).executeUpdate();
        }));
        this.deleteOldCacheEntities(CacheCompany.class, oldCompanies, companies, null);
        this.em.flush();
        this.em.clear();
        log.info("Updated cache: {} groups, {} companies, {} users, {} memberships, {} project groups, {} updated delegates in {}", new Object[]{groups.size(), companies.size(), users.size(), memberships, subscribedProjects, updatedDelegate, DurationFormatUtils.formatDurationHMS((long)(System.currentTimeMillis() - start))});
        this.cacheRefreshTime = System.currentTimeMillis();
    }

    private <T extends Persistable<String>> void deleteOldCacheEntities(Class<T> entityClass, Map<String, T> oldEntities, Map<String, ?> newEntities, Consumer<List<String>> onDelete) {
        Set<String> ids = oldEntities.keySet();
        ids.removeAll(newEntities.keySet());
        ArrayList<String> idsAsList = new ArrayList<String>(ids);
        if (onDelete != null) {
            onDelete.accept(idsAsList);
        }
        this.deleteBatch(entityClass, idsAsList, sIds -> this.em.createQuery("DELETE FROM " + entityClass.getSimpleName() + " WHERE id in (:ids)").setParameter("ids", sIds).executeUpdate());
    }

    private CacheCompany toCacheCompany(CompanyOrg company, CacheCompany entity) {
        return this.fillCacheContainer((ContainerOrg)company, entity);
    }

    private CacheGroup toCacheGroup(GroupOrg group, CacheGroup entity) {
        return this.fillCacheContainer((ContainerOrg)group, entity);
    }

    private CacheUser toCacheUser(UserOrg user) {
        return this.toCacheUserInternal(user, new CacheUser(), null);
    }

    private CacheUser toCacheUserInternal(UserOrg user, CacheUser entity, Map<String, CacheCompany> companies) {
        entity.setId((Serializable)((Object)user.getId()));
        entity.setFirstName(user.getFirstName());
        entity.setLastName(user.getLastName());
        if (CollectionUtils.isNotEmpty((Collection)user.getMails())) {
            entity.setMails((String)user.getMails().getFirst());
        }
        entity.setCompany((CacheCompany)Optional.ofNullable(user.getCompany()).map(c -> {
            if (companies == null) {
                CacheCompany company = new CacheCompany();
                company.setId((Serializable)((Object)c));
                return company;
            }
            return (CacheCompany)companies.get(c);
        }).orElse(null));
        return entity;
    }

    @Override
    public void update(UserOrg user) {
        CacheUser entity = this.toCacheUser(user);
        this.em.merge((Object)entity);
        this.em.flush();
        this.em.clear();
    }

    private long updateDelegateDn(Map<String, ? extends CacheContainer> containers, Object type, String typePath, Function<DelegateOrg, String> id, Function<DelegateOrg, String> getDn, BiConsumer<DelegateOrg, String> setDn) {
        AtomicInteger updated = new AtomicInteger();
        this.delegateOrgRepository.findAllBy(typePath, type).stream().filter(d -> {
            String dn = Optional.ofNullable((CacheContainer)containers.get(id.apply((DelegateOrg)d))).map(CacheContainer::getDescription).orElse(null);
            String delegateDn = (String)getDn.apply((DelegateOrg)d);
            if (delegateDn == null) {
                return false;
            }
            if (dn == null) {
                return true;
            }
            if (!delegateDn.equalsIgnoreCase(dn)) {
                setDn.accept((DelegateOrg)d, dn);
                updated.incrementAndGet();
            }
            return false;
        }).forEach(arg_0 -> ((DelegateOrgRepository)this.delegateOrgRepository).delete(arg_0));
        return updated.get();
    }

    private long updateDelegateDn(Map<String, ? extends CacheContainer> containers, ReceiverType receiverType, DelegateType resourceType) {
        long count = this.updateDelegateDn(containers, receiverType, "receiverType", AbstractDelegate::getReceiver, DelegateOrg::getReceiverDn, DelegateOrg::setReceiverDn);
        return count += this.updateDelegateDn(containers, resourceType, "type", AbstractNamedAuditedEntity::getName, DelegateOrg::getDn, DelegateOrg::setDn);
    }

    private long updateDelegateDn(Map<String, CacheGroup> groups, Map<String, CacheCompany> companies) {
        return this.updateDelegateDn(groups, ReceiverType.GROUP, DelegateType.GROUP) + this.updateDelegateDn(companies, ReceiverType.COMPANY, DelegateType.COMPANY);
    }

    @Override
    @Generated
    public long getCacheRefreshTime() {
        return this.cacheRefreshTime;
    }
}

