/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.VisibleCombinedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String SETTINGS = "META-INF/jetty/jetty-dev.properties";
    private final Server server = new Server();
    private static Server lastStartedServer;

    public Main() throws Exception {
        String jettyPropertiesFile = System.getProperty("jetty.properties", SETTINGS);
        this.configure(jettyPropertiesFile);
        log.debug("Loading Jetty Settings from {}", (Object)SETTINGS);
    }

    private void configure(String jettyPropertiesFile) throws Exception {
        try (InputStream propertiesInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(jettyPropertiesFile);){
            if (propertiesInput == null) {
                log.error("Unable to find jetty properties file: {}", (Object)jettyPropertiesFile);
            } else {
                this.copyProperties(propertiesInput);
                if (System.getProperty("jetty.port") != null) {
                    HttpConfiguration httpConfig = new HttpConfiguration();
                    httpConfig.setSecureScheme("https");
                    httpConfig.setSecurePort(8443);
                    httpConfig.setOutputBufferSize(32768);
                    httpConfig.setResponseHeaderSize(8192);
                    httpConfig.setRequestHeaderSize(8192);
                    HttpConnectionFactory factory = new HttpConnectionFactory(httpConfig);
                    ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{factory});
                    connector.setHost(System.getProperty("jetty.host", "localhost"));
                    connector.setPort(Integer.parseInt(System.getProperty("jetty.port", "8080"), 10));
                    connector.setIdleTimeout(30000L);
                    this.server.setConnectors(new Connector[]{connector});
                }
                if (System.getProperty("jetty.webapp") != null) {
                    ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[0]);
                    this.server.setHandler((Handler)contexts);
                    WebAppContext webContext = new WebAppContext();
                    webContext.setContextPath(System.getProperty("jetty.contextPath", "/bootstrap-business"));
                    webContext.setDescriptor(System.getProperty("jetty.descriptor"));
                    PathResourceFactory pathFactory = new PathResourceFactory();
                    Resource resourceCollection = VisibleCombinedResource.combine(pathFactory.newResource(System.getProperty("jetty.webapp", ".")), pathFactory.newResource(System.getProperty("jetty.target", "./WEB-INF/classes")));
                    webContext.setBaseResource(resourceCollection);
                    webContext.setResourceAlias("/WEB-INF/classes/", "/classes/");
                    webContext.setExtraClasspath("./target/classes/");
                    contexts.addHandler((Handler)webContext);
                }
                this.server.setAttribute("stopAtShutdown", (Object)true);
            }
        }
    }

    private void copyProperties(InputStream propertiesInput) throws IOException {
        Properties properties = new Properties();
        properties.load(propertiesInput);
        properties.putAll((Map<?, ?>)System.getProperties());
        System.setProperties(properties);
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        main.server.start();
        lastStartedServer = main.server;
        main.server.join();
    }

    @Generated
    public Server getServer() {
        return this.server;
    }

    @Generated
    public static Server getLastStartedServer() {
        return lastStartedServer;
    }
}

