/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import com.github.tomakehurst.wiremock.WireMockServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.ligoj.bootstrap.AbstractAppTest;

public abstract class AbstractServerTest
extends AbstractAppTest {
    protected static final int MOCK_PORT = 8120;
    protected WireMockServer httpServer;

    @BeforeEach
    public void prepareMockServer() {
        if (this.httpServer != null) {
            throw new IllegalStateException("A previous HTTP server was already created");
        }
        this.httpServer = new WireMockServer(8120);
        System.setProperty("http.keepAlive", "false");
    }

    @AfterEach
    public void shutDownMockServer() {
        System.clearProperty("http.keepAlive");
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                this.log.info("Jetty server did not stopped properly {}", (Object)e.getClass().getName());
            }
        }
    }
}

