/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.ligoj.bootstrap.AbstractTest;
import org.ligoj.bootstrap.http.server.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestTest
extends AbstractTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRestTest.class);
    private static final String PORT = "6380";
    protected static final String BASE_URI = "http://localhost:6380/bootstrap-business/rest";
    protected static final String DEFAULT_USER = "junit";
    private static final int DEFAULT_RETRIES = 20;
    int retries = 20;
    protected CloseableHttpClient httpclient = HttpClientBuilder.create().build();

    @BeforeEach
    public void configureClient() {
        this.retries = 20;
        this.httpclient = HttpClientBuilder.create().build();
    }

    @AfterEach
    public void closeClient() {
        AbstractRestTest.closeQuietly((Closeable)this.httpclient);
    }

    private void initProperties(String webDescriptor) {
        if (StringUtils.isBlank((CharSequence)webDescriptor)) {
            System.clearProperty("jetty.descriptor");
        } else {
            System.setProperty("jetty.descriptor", webDescriptor);
        }
        System.setProperty("jetty.port", PORT);
        System.setProperty("user.language", "en_en");
        System.setProperty("user.language", "en_en");
        System.setProperty("app.crypto.file", "src/test/resources/security.key");
        System.setProperty("org.eclipse.jetty.server.webapp.parentLoaderPriority", "true");
    }

    private String getPingUri() {
        return "http://localhost:6380/bootstrap-business/rest?_wadl";
    }

    protected Server startRestServer(String webDescriptor) {
        this.initProperties(webDescriptor);
        try {
            Server server = new Main().getServer();
            server.start();
            this.waitForServerReady();
            return server;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start correctly the server", e);
        }
    }

    private void waitForServerReady() throws IOException, InterruptedException {
        HttpGet httpget = new HttpGet(this.getPingUri());
        int counter = 0;
        while (true) {
            try {
                if (200 == (Integer)this.httpclient.execute((ClassicHttpRequest)httpget, HttpResponse::getCode)) break;
                this.checkRetries(counter);
            }
            catch (HttpHostConnectException ex) {
                log.info("Check failed, retrying...");
                this.checkRetries(counter);
            }
            ++counter;
        }
    }

    protected String execute(ClassicHttpRequest httpRequest) throws IOException {
        return (String)this.httpclient.execute(httpRequest, response -> IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
    }

    private void checkRetries(int counter) throws InterruptedException {
        if (counter > this.retries) {
            throw new IllegalStateException("Remote server did not started correctly");
        }
        Thread.sleep(2000L);
    }
}

