/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap.model;

import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import jodd.bean.BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public abstract class AbstractBusinessEntityTest {
    private static final BeanUtil BEAN_UTIL = BeanUtil.declaredSilent;

    protected <T> void testEqualsAndHash(Class<T> modelClass) throws ReflectiveOperationException {
        this.testEqualsAndHash(modelClass, "id");
    }

    protected <T> void testEqualsAndHash(Class<T> modelClass, String ... idProperties) throws ReflectiveOperationException {
        T systemUser = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        T systemUser2 = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Assertions.assertFalse((boolean)systemUser.equals(null));
        Assertions.assertEquals(systemUser, systemUser);
        Assertions.assertEquals(systemUser, systemUser2);
        Assertions.assertFalse((boolean)systemUser.equals(1));
        Assertions.assertNotSame((Object)0, (Object)systemUser.hashCode());
        List<List<String>> combinations = this.combinations(idProperties);
        this.testCombinations(modelClass, combinations);
        Object mockCanEqual = Mockito.mock(modelClass);
        systemUser.equals(mockCanEqual);
    }

    private <T> void setValues(T beanValued, List<String> combination) {
        for (String propertyString : combination) {
            BEAN_UTIL.setProperty(beanValued, propertyString, (Object)1);
        }
    }

    private <T> void testCombinations(Class<T> modelClass, List<List<String>> combinations) throws ReflectiveOperationException {
        for (List<String> combination : combinations) {
            T beanValued = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setValues(beanValued, combination);
            this.testCombinations(modelClass, combinations, combination, beanValued);
            Assertions.assertNotSame((Object)0, (Object)beanValued.hashCode());
        }
    }

    private <T> void testCombinations(Class<T> modelClass, List<List<String>> combinations, List<String> combination, T beanValued) throws ReflectiveOperationException {
        for (List<String> properties : combinations) {
            this.testCombination(modelClass, combination, beanValued, properties);
        }
    }

    private <T> void testCombination(Class<T> modelClass, List<String> combination, T beanValued, List<String> properties) throws ReflectiveOperationException {
        T beanValued2 = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.setValues(beanValued2, properties);
        Assertions.assertEquals((Object)properties.equals(combination), (Object)beanValued.equals(beanValued2));
    }

    private List<List<String>> combinations(String ... array) {
        long count = 2 << array.length - 1;
        LinkedList<List<String>> totalCombinations = new LinkedList<List<String>>();
        int i = 0;
        while ((long)i < count) {
            LinkedList<String> combinations = new LinkedList<String>();
            this.addPropertyCombinations(i, combinations, array);
            totalCombinations.add(combinations);
            ++i;
        }
        return totalCombinations;
    }

    private void addPropertyCombinations(int i, List<String> combinations, String ... array) {
        for (int j = 0; j < array.length; ++j) {
            if ((i & 1 << j) == 0) continue;
            combinations.add(array[j]);
        }
    }

    protected <T> T testPojo(Class<T> pojo) throws ReflectiveOperationException {
        T bean = pojo.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : FieldUtils.getAllFields(pojo)) {
            if (field.getName().contains("$") || Modifier.isStatic(field.getModifiers())) continue;
            String setter = "set" + StringUtils.capitalize((String)field.getName());
            String getter = "get" + StringUtils.capitalize((String)field.getName());
            Constable param = null;
            Class<?> type = field.getType();
            if (type.equals(Double.TYPE)) {
                param = 0.0;
            } else if (type.equals(Boolean.TYPE)) {
                getter = "is" + StringUtils.capitalize((String)field.getName());
                param = Boolean.valueOf(false);
            }
            pojo.getMethod(setter, type).invoke(bean, param);
            pojo.getMethod(getter, new Class[0]).invoke(bean, new Object[0]);
        }
        return bean;
    }
}

