/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.security.Permission;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractTest.class);
    protected static final int MOCK_PORT = 8120;
    protected static final ThreadLocal<SecurityManager> SECURITY_MANAGER_THREAD = new ThreadLocal();

    @BeforeEach
    public void injectMock() throws Exception {
        MockitoAnnotations.openMocks((Object)this).close();
    }

    protected static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @BeforeAll
    public static void forbidSystemExitCall() {
        SECURITY_MANAGER_THREAD.set(new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName().startsWith("exitVM") && !"-local".equals(System.getProperty("app-env", "-local"))) {
                    log.error("Something called exit within test executions", (Throwable)new IllegalStateException("Something called exit within test executions"));
                }
            }
        });
        System.setSecurityManager(SECURITY_MANAGER_THREAD.get());
    }

    @AfterAll
    public static void restoreSystemExitCall() {
        System.setSecurityManager(SECURITY_MANAGER_THREAD.get());
    }
}

