/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.ligoj.bootstrap.AbstractDataGeneratorTest;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public abstract class AbstractSecurityTest
extends AbstractDataGeneratorTest {
    protected static final String DEFAULT_USER = "junit";
    protected static final String DEFAULT_ROLE = "junit_R";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String USER_DETAILS_NA = "N/A";

    @BeforeEach
    public void setUp() {
        this.initSpringSecurityContext(this.getAuthenticationName(), new GrantedAuthority[0]);
    }

    protected org.springframework.security.core.context.SecurityContext initSpringSecurityContext(String user, GrantedAuthority ... authorities) {
        SecurityContextHolder.clearContext();
        org.springframework.security.core.context.SecurityContext context = (org.springframework.security.core.context.SecurityContext)Mockito.mock(org.springframework.security.core.context.SecurityContext.class);
        Authentication authentication = (Authentication)Mockito.mock(Authentication.class);
        List<GrantedAuthority> authoritiesAsList = Arrays.asList(authorities);
        User userDetails = new User(user, USER_DETAILS_NA, authoritiesAsList);
        Mockito.when((Object)((List)authentication.getAuthorities())).thenReturn(authoritiesAsList);
        Mockito.when((Object)context.getAuthentication()).thenReturn((Object)authentication);
        Mockito.when((Object)authentication.getPrincipal()).thenReturn((Object)userDetails);
        Mockito.when((Object)authentication.getName()).thenReturn((Object)user);
        SecurityContextHolder.setContext((org.springframework.security.core.context.SecurityContext)context);
        return context;
    }

    @AfterEach
    public void cleanup() {
        SecurityContextHolder.clearContext();
    }

    protected String getAuthenticationName() {
        return DEFAULT_USER;
    }

    protected SecurityContext getJaxRsSecurityContext(String user) {
        SecurityContext context = (SecurityContext)Mockito.mock(SecurityContext.class);
        Principal principal = (Principal)Mockito.mock(Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)user);
        Mockito.when((Object)context.getUserPrincipal()).thenReturn((Object)principal);
        return context;
    }
}

