/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.ligoj.bootstrap.AbstractTest;
import org.ligoj.bootstrap.http.server.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRestTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestTest.class);
    private static final String PORT = "6380";
    private static final String BASE_URI = "http://localhost:6380/bootstrap-business/rest";
    protected static final String DEFAULT_USER = "junit";
    private static final int DEFAULT_RETRIES = 20;
    int retries = 20;
    CloseableHttpClient httpclient = HttpClientBuilder.create().build();

    AbstractRestTest() {
    }

    @BeforeEach
    public void configureClient() {
        this.retries = 20;
        this.httpclient = HttpClientBuilder.create().build();
    }

    @AfterEach
    public void closeClient() {
        AbstractRestTest.closeQuietly((Closeable)this.httpclient);
    }

    private void initProperties(String webDescriptor) {
        System.setProperty("jetty.descriptor", webDescriptor);
        System.setProperty("jetty.port", PORT);
        System.setProperty("user.language", "en_en");
        System.setProperty("org.eclipse.jetty.server.webapp.parentLoaderPriority", "true");
    }

    private String getPingUri() {
        return "http://localhost:6380/bootstrap-business/rest?_wadl";
    }

    Server startRestServer(String webDescriptor) {
        this.initProperties(webDescriptor);
        try {
            Server server = new Main().getServer();
            server.start();
            this.waitForServerReady();
            return server;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to start correctly the server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerReady() throws IOException, InterruptedException {
        HttpGet httpget = new HttpGet(this.getPingUri());
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 404, ""));
        int counter = 0;
        while (true) {
            try {
                response = this.httpclient.execute((HttpUriRequest)httpget);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) break;
                this.checkRetries(counter);
            }
            catch (HttpHostConnectException ex) {
                log.info("Check failed, retrying...");
                this.checkRetries(counter);
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            ++counter;
        }
    }

    private void checkRetries(int counter) throws InterruptedException {
        if (counter > this.retries) {
            throw new IllegalStateException("Remote server did not started correctly");
        }
        Thread.sleep(2000L);
    }
}

