/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.ws.rs.core.UriInfo;
import org.hibernate.collection.internal.PersistentBag;
import org.junit.jupiter.api.BeforeAll;
import org.ligoj.bootstrap.AbstractSecurityTest;
import org.ligoj.bootstrap.core.crypto.CryptoHelper;
import org.ligoj.bootstrap.core.dao.csv.CsvForJpa;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractJpaTest
extends AbstractSecurityTest {
    @Autowired
    protected CsvForJpa csvForJpa;
    @Autowired
    protected CryptoHelper cryptoHelper;
    @Autowired
    protected CacheManager cacheManager;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION, unitName="pu")
    protected EntityManager em;

    @BeforeAll
    static void init() {
        System.setProperty("app.crypto.file", "src/test/resources/security.key");
    }

    protected void clearAllCache() {
        this.cacheManager.getCacheNames().stream().map(arg_0 -> ((CacheManager)this.cacheManager).getCache(arg_0)).forEach(Cache::clear);
    }

    protected <T> List<T> persistEntities(Class<T> clazz, String resource) throws IOException {
        return this.persistEntities(clazz, resource, "cp1250");
    }

    private <T> List<T> persistEntities(Class<T> clazz, String resource, String encoding) throws IOException {
        List list = this.csvForJpa.toJpa(clazz, (Reader)new InputStreamReader(new ClassPathResource(resource).getInputStream(), encoding), true, true);
        this.em.flush();
        this.em.clear();
        return list;
    }

    protected UriInfo persistEntities(String csvRoot, Class<?> ... entityModel) throws IOException {
        return this.persistEntities(csvRoot, entityModel, "cp1250");
    }

    protected UriInfo persistEntities(String csvRoot, Class<?>[] entityModel, String encoding) throws IOException {
        this.csvForJpa.reset(csvRoot, (Class[])entityModel, encoding);
        return this.newUriInfo();
    }

    protected boolean isLazyInitialized(Collection<?> bag) {
        return bag instanceof PersistentBag && ((PersistentBag)bag).wasInitialized();
    }
}

