/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.bootstrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.ligoj.bootstrap.AbstractTest;
import org.ligoj.bootstrap.core.DateUtils;
import org.ligoj.bootstrap.core.SpringUtils;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractDataGeneratorTest
extends AbstractTest
implements ApplicationContextAware {
    protected final Random random = new SecureRandom();
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @AfterEach
    @BeforeEach
    public void restoreApplicationContext() {
        if (this.applicationContext != null) {
            SpringUtils.setSharedApplicationContext((ApplicationContext)this.applicationContext);
        }
    }

    protected int getInt(String salt) {
        return Math.abs(Math.max(Integer.MIN_VALUE, salt.hashCode()));
    }

    protected int getInt(int salt, int lower, int upper) {
        if (lower >= upper) {
            return lower;
        }
        return Math.abs(salt) % (upper - lower) + lower;
    }

    protected int getInt(String salt, int lower, int upper) {
        return this.getInt(this.getInt(salt), lower, upper);
    }

    protected Date getDate(String salt) {
        return this.getDate(this.getInt(salt));
    }

    protected Date getDate(int year, int month, int day, int hour, int minute, int second) {
        Calendar calendar = DateUtils.newCalendar();
        calendar.clear();
        calendar.set(year, month - 1, day, hour, minute, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected Date getDate(int year, int month, int day) {
        return this.getDate(year, month, day, 0, 0, 0);
    }

    protected Date getDate(int salt) {
        Calendar manufacturingDate = DateUtils.newCalendar();
        manufacturingDate.set(1, this.getInt(salt, 1970, 1988));
        manufacturingDate.set(2, this.getInt(salt, 0, 11));
        manufacturingDate.set(5, this.getInt(salt, 1, 28));
        manufacturingDate.set(11, 0);
        manufacturingDate.set(12, 0);
        manufacturingDate.set(13, 0);
        manufacturingDate.set(14, 0);
        return manufacturingDate.getTime();
    }

    protected Date now() {
        return DateUtils.newCalendar().getTime();
    }

    protected char getChar(int anyInt) {
        return (char)(65 + this.getInt(anyInt, 0, 26));
    }

    protected char getChar(String anyInt) {
        return (char)(65 + this.getInt(anyInt, 0, 26));
    }

    protected double getDouble(String salt, int lower, int upper) {
        this.random.setSeed(salt.hashCode());
        return this.random.nextDouble() * (double)(upper - lower) + (double)lower;
    }

    protected <T> T getItem(String salt, List<T> items) {
        return items.get(this.getInt(salt, 0, items.size()));
    }

    protected <T> T getItem(int salt, List<T> items) {
        return items.get(this.getInt(salt, 0, items.size()));
    }

    @SafeVarargs
    protected final <T> T getItem(String salt, T ... items) {
        return items[this.getInt(salt, 0, items.length)];
    }

    protected <T> T getItemOrNull(String salt, List<T> items) {
        int index = this.getInt(salt, 0, items.size() + 1) - 1;
        if (index == -1) {
            return null;
        }
        return items.get(index);
    }

    protected <T> T getItemOrNull(int salt, List<T> items) {
        int index = this.getInt(salt, 0, items.size() + 1) - 1;
        if (index == -1) {
            return null;
        }
        return items.get(index);
    }

    @SafeVarargs
    protected final <T> T getItemOrNull(String salt, T ... items) {
        int index = this.getInt(salt, 0, items.length + 1) - 1;
        if (index == -1) {
            return null;
        }
        return items[index];
    }

    protected <T> T getEnum(String salt, Class<T> enumClass) {
        return this.getItem(salt, enumClass.getEnumConstants());
    }

    protected <T> List<T> getItems(String salt, List<T> items, int lower, int upper) {
        ArrayList<T> result = new ArrayList<T>(upper);
        int size = Math.min(items.size(), this.getInt(salt, lower, upper));
        HashSet<Integer> added = new HashSet<Integer>(upper);
        int counter = size;
        int saltIncrement = 0;
        while (counter != 0) {
            int index;
            if (!added.add(index = this.getInt(salt + counter + saltIncrement++, 0, items.size()))) continue;
            --counter;
            result.add(items.get(index));
        }
        return result;
    }

    protected Boolean getBoolean(String salt) {
        return this.getBoolean(this.getInt(salt));
    }

    protected Boolean getBoolean(int salt) {
        return this.getInt(salt, 0, 2) == 1;
    }

    protected UriInfo newUriInfo() {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Mockito.when((Object)uriInfo.getQueryParameters()).thenReturn((Object)new MetadataMap());
        return uriInfo;
    }

    protected UriInfo newUriInfo(String search) {
        UriInfo uriInfo = this.newUriInfo();
        uriInfo.getQueryParameters().putSingle((Object)"search[value]", (Object)search);
        return uriInfo;
    }

    protected <T> void coverageSingleton(Class<T> singletonClass) throws ReflectiveOperationException {
        Constructor<T> constructor = singletonClass.getDeclaredConstructor(new Class[0]);
        Assertions.assertTrue((boolean)Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }
}

