/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.socket.ConnectionDescriptor;
import com.sun.star.lib.connections.socket.SocketConnection;
import com.sun.star.registry.XRegistryKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public final class socketConnector
implements XConnector {
    public static final String __serviceName = "com.sun.star.connection.socketConnector";
    private boolean connected = false;

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory multiFactory, XRegistryKey regKey) {
        return implName.equals(socketConnector.class.getName()) ? FactoryHelper.getServiceFactory(socketConnector.class, __serviceName, multiFactory, regKey) : null;
    }

    public synchronized XConnection connect(String connectionDescription) throws NoConnectException, ConnectionSetupException {
        SocketConnection con;
        InetAddress[] adr;
        ConnectionDescriptor desc;
        if (this.connected) {
            throw new ConnectionSetupException("alread connected");
        }
        try {
            desc = new ConnectionDescriptor(connectionDescription);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectionSetupException((Throwable)e);
        }
        if (desc.getHost() == null) {
            throw new ConnectionSetupException("host parameter missing");
        }
        try {
            adr = InetAddress.getAllByName(desc.getHost());
        }
        catch (UnknownHostException e) {
            throw new ConnectionSetupException((Throwable)e);
        }
        Socket socket = null;
        boolean isLoopbackAddress = false;
        for (int i = 0; i < adr.length; ++i) {
            try {
                isLoopbackAddress = adr[i].isLoopbackAddress();
                socket = new Socket(adr[i], desc.getPort());
                break;
            }
            catch (IOException e) {
                if (i != adr.length - 1) continue;
                throw new NoConnectException((Throwable)e);
            }
        }
        try {
            if (desc.getTcpNoDelay() != null) {
                socket.setTcpNoDelay(desc.getTcpNoDelay());
            } else if (isLoopbackAddress) {
                socket.setTcpNoDelay(true);
            }
            con = new SocketConnection(connectionDescription, socket);
        }
        catch (IOException e) {
            throw new NoConnectException((Throwable)e);
        }
        this.connected = true;
        return con;
    }
}

