/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import com.sun.jna.Memory;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.liblouis.DisplayTable;
import org.liblouis.WideChar;

public final class WideString
extends PointerType
implements NativeMapped {
    private static Map<Charset, CharsetEncoder> encoders;
    private static Map<Charset, CharsetDecoder> decoders;
    private final int length;

    public WideString() {
        this(0);
    }

    WideString(int length) {
        this.length = length;
    }

    WideString(String value) {
        this(value.length());
        try {
            this.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    WideString(Pointer p, int offset, int length) {
        this(length);
        this.setPointer(p.share((long)(offset * WideChar.SIZE)));
    }

    String read(int length) throws CharacterCodingException, IOException {
        return this.read(length, DisplayTable.StandardDisplayTables.DEFAULT);
    }

    String readDots(int length) throws UnmappableCharacterException, IOException {
        return this.read(length, DisplayTable.StandardDisplayTables.UNICODE);
    }

    String read(int length, DisplayTable displayTable) throws UnmappableCharacterException, IOException {
        CharsetDecoder decoder;
        Charset charset = displayTable.asCharset();
        if (decoders == null) {
            decoders = new IdentityHashMap<Charset, CharsetDecoder>();
        }
        if ((decoder = decoders.get(charset)) == null) {
            decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            decoders.put(charset, decoder);
        }
        return this.read(length, decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(int length, CharsetDecoder decoder) throws UnmappableCharacterException, IOException {
        CharsetDecoder charsetDecoder = decoder;
        synchronized (charsetDecoder) {
            if (length > this.length()) {
                throw new IOException("Maximum length is " + this.length());
            }
            if (length == 0) {
                return "";
            }
            decoder.reset();
            ByteBuffer bytes = ByteBuffer.wrap(this.getPointer().getByteArray(0L, length * WideChar.SIZE));
            CharBuffer chars = CharBuffer.allocate((int)((float)bytes.limit() * decoder.averageCharsPerByte()));
            while (true) {
                CoderResult cr;
                CoderResult coderResult = cr = bytes.hasRemaining() ? decoder.decode(bytes, chars, true) : decoder.flush(chars);
                if (cr.isUnderflow()) break;
                if (cr.isOverflow()) {
                    CharBuffer b = CharBuffer.allocate(chars.limit() * 2);
                    chars.flip();
                    b.put(chars);
                    chars = b;
                    continue;
                }
                try {
                    cr.throwException();
                }
                catch (MalformedInputException e) {
                    throw new RuntimeException("Liblouis coding error", e);
                }
            }
            chars.flip();
            return chars.toString();
        }
    }

    WideString write(String value) throws IOException {
        return this.write(value, DisplayTable.StandardDisplayTables.DEFAULT);
    }

    WideString writeDots(String value) throws UnmappableCharacterException, IOException {
        return this.write(value, DisplayTable.StandardDisplayTables.UNICODE);
    }

    private WideString write(String value, DisplayTable displayTable) throws UnmappableCharacterException, IOException {
        CharsetEncoder encoder;
        Charset charset = displayTable.asCharset();
        if (encoders == null) {
            encoders = new IdentityHashMap<Charset, CharsetEncoder>();
        }
        if ((encoder = encoders.get(charset)) == null) {
            encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            encoders.put(charset, encoder);
        }
        return this.write(value, encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WideString write(String value, CharsetEncoder encoder) throws UnmappableCharacterException, IOException {
        CharsetEncoder charsetEncoder = encoder;
        synchronized (charsetEncoder) {
            if (encoder.charset() != DisplayTable.StandardDisplayTables.DEFAULT.asCharset() && encoder.charset() != DisplayTable.StandardDisplayTables.UNICODE.asCharset()) {
                throw new IllegalStateException();
            }
            int encodedLength = WideChar.SIZE * (WideChar.SIZE == 2 ? value.length() : value.codePoints().toArray().length);
            if (encodedLength > this.length * WideChar.SIZE) {
                throw new IOException("Maximum string length is " + this.length());
            }
            byte[] ba = new byte[encodedLength];
            if (ba.length > 0) {
                ByteBuffer bb = ByteBuffer.wrap(ba);
                CharBuffer cb = CharBuffer.wrap(value);
                encoder.reset();
                CoderResult cr = encoder.encode(cb, bb, true);
                try {
                    if (!cr.isUnderflow()) {
                        cr.throwException();
                    }
                    if (!(cr = encoder.flush(bb)).isUnderflow()) {
                        cr.throwException();
                    }
                }
                catch (BufferOverflowException e) {
                    throw new RuntimeException("invalid Charset", e);
                }
                if (bb.hasRemaining()) {
                    throw new RuntimeException("invalid Charset");
                }
                this.getPointer().write(0L, ba, 0, ba.length);
            }
            return this;
        }
    }

    public Pointer getPointer() {
        if (super.getPointer() == null) {
            try {
                this.setPointer((Pointer)new Memory((long)(this.length * WideChar.SIZE)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.getPointer();
    }

    int length() {
        return this.length;
    }

    WideString substring(int beginIndex) {
        return this.substring(beginIndex, this.length);
    }

    WideString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new WideString(this.getPointer(), beginIndex, endIndex - beginIndex);
    }

    public String toString() {
        try {
            return this.read(this.length());
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
    }
}

