/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Arrays;

public class Utilities {
    private static Object libc;

    static {
        switch (Platform.getOSType()) {
            case 0: 
            case 1: {
                libc = Native.loadLibrary((String)"c", UnixCLibrary.class);
                break;
            }
            case 2: {
                libc = Native.loadLibrary((String)"msvcrt", WindowsCLibrary.class);
            }
        }
    }

    public static interface WindowsCLibrary
    extends Library {
        public int _putenv(String var1);
    }

    public static interface UnixCLibrary
    extends Library {
        public int setenv(String var1, String var2, int var3);
    }

    public static class Environment {
        public static void setLouisTablePath(String value) {
            if (libc instanceof UnixCLibrary) {
                ((UnixCLibrary)libc).setenv("LOUIS_TABLEPATH", value, 1);
            } else {
                ((WindowsCLibrary)libc)._putenv("LOUIS_TABLEPATH=");
                ((WindowsCLibrary)libc)._putenv("LOUIS_TABLEPATH=" + value);
            }
        }
    }

    public static class Hyphenation {
        public static Pair<String, byte[]> extractHyphens(String string, Character shy, Character zwsp) {
            if (!(shy != null && string.contains(String.valueOf(shy)) || zwsp != null && string.contains(String.valueOf(zwsp)))) {
                return new Pair<String, Object>(string, null);
            }
            boolean SHY = true;
            int ZWSP = 2;
            StringBuffer unhyphenatedString = new StringBuffer();
            byte[] hyphens = new byte[string.length() / 2];
            int j = 0;
            boolean seenShy = false;
            boolean seenZwsp = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == shy.charValue()) {
                    seenShy = true;
                    continue;
                }
                if (c == zwsp.charValue()) {
                    seenZwsp = true;
                    continue;
                }
                unhyphenatedString.append(c);
                hyphens[j++] = seenShy ? 1 : (seenZwsp ? 2 : 0);
                seenShy = false;
                seenZwsp = false;
            }
            return new Pair<String, byte[]>(unhyphenatedString.toString(), Arrays.copyOf(hyphens, j - 1));
        }

        public static String insertHyphens(String string, byte[] hyphens, Character shy, Character zwsp) {
            int i;
            if (shy == null && zwsp == null || hyphens == null) {
                return string;
            }
            boolean SHY = true;
            int ZWSP = 2;
            if (string.equals("")) {
                return "";
            }
            if (hyphens.length != string.length() - 1) {
                throw new RuntimeException("hyphens.length must be equal to string.length() - 1");
            }
            StringBuffer hyphenatedString = new StringBuffer();
            for (i = 0; i < hyphens.length; ++i) {
                hyphenatedString.append(string.charAt(i));
                if (shy != null && hyphens[i] == 1) {
                    hyphenatedString.append(shy);
                    continue;
                }
                if (zwsp == null || hyphens[i] != 2) continue;
                hyphenatedString.append(zwsp);
            }
            hyphenatedString.append(string.charAt(i));
            return hyphenatedString.toString();
        }
    }

    public static class Pair<T1, T2> {
        public final T1 _1;
        public final T2 _2;

        public Pair(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }
    }
}

