/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.liblouis.CompilationException;
import org.liblouis.DisplayException;
import org.liblouis.DisplayTable;
import org.liblouis.Logger;
import org.liblouis.Louis;
import org.liblouis.Table;
import org.liblouis.TranslationException;
import org.liblouis.TranslationResult;
import org.liblouis.Typeform;
import org.liblouis.WideChar;
import org.liblouis.WideString;

public class Translator {
    public static final byte SHY = 1;
    public static final byte ZWSP = 2;
    private final String table;
    private DisplayTable displayTable = null;
    private Set<Typeform> typeforms = null;
    private static final int OUTLEN_MULTIPLIER = WideChar.SIZE * 2 + 4;
    private static ThreadLocal<Buffers> buffers = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };

    public Translator(String table) throws CompilationException {
        Louis.log(Logger.Level.DEBUG, "Loading table %s", table);
        if (Louis.getLibrary().lou_getTable(table) == Pointer.NULL) {
            throw new CompilationException("Unable to compile table '" + table + "'");
        }
        this.table = table;
    }

    public Translator(URL table) throws CompilationException {
        Louis.log(Logger.Level.DEBUG, "Loading table %s", table);
        this.table = Louis.getTableNameForURL(table);
        if (Louis.getLibrary().lou_getTable(this.table) == Pointer.NULL) {
            throw new CompilationException("Unable to compile table '" + table + "'");
        }
    }

    public static Translator find(String query) throws IllegalArgumentException, CompilationException {
        try {
            return Table.find(query).getTranslator();
        }
        catch (NoSuchElementException e) {
            throw new CompilationException(e);
        }
    }

    public String getTable() {
        return this.table;
    }

    public Set<Typeform> getSupportedTypeforms() {
        if (this.typeforms == null) {
            this.typeforms = new HashSet<Typeform>();
            short value = 1;
            for (String emphClass : Louis.getLibrary().lou_getEmphClasses(this.table)) {
                this.typeforms.add(new Typeform(emphClass, value, this));
                value = (short)(value * 2);
            }
            this.typeforms = Collections.unmodifiableSet(this.typeforms);
        }
        return this.typeforms;
    }

    public TranslationResult translate(String text, Typeform[] typeform, int[] characterAttributes, int[] interCharacterAttributes) throws TranslationException, DisplayException {
        return this.translate(text, typeform, characterAttributes, interCharacterAttributes, DisplayTable.StandardDisplayTables.DEFAULT);
    }

    private TranslationResult translate(String text, short[] typeform, int[] characterAttributes, int[] interCharacterAttributes) throws TranslationException, DisplayException {
        return this.translate(text, typeform, characterAttributes, interCharacterAttributes, DisplayTable.StandardDisplayTables.DEFAULT);
    }

    public TranslationResult translate(String text, Typeform[] typeform, int[] characterAttributes, int[] interCharacterAttributes, DisplayTable displayTable) throws TranslationException, DisplayException {
        short[] tf = null;
        if (typeform != null) {
            tf = new short[typeform.length];
            for (int i = 0; i < typeform.length; ++i) {
                if (typeform[i] == null) {
                    tf[i] = 0;
                    continue;
                }
                if (typeform[i].table != null && !typeform[i].table.equals(this)) {
                    throw new TranslationException("Can not use a typeform defined in another table.");
                }
                tf[i] = typeform[i].value;
            }
        }
        return this.translate(text, tf, characterAttributes, interCharacterAttributes, displayTable);
    }

    private TranslationResult translate(String text, short[] typeform, int[] characterAttributes, int[] interCharacterAttributes, DisplayTable displayTable) throws TranslationException, DisplayException {
        WideString inbuf;
        int textLength = text.codePoints().toArray().length;
        if (WideChar.SIZE == 2 && textLength != text.length()) {
            textLength = text.length();
            if (typeform != null) {
                throw new IllegalArgumentException("Unicode characters above U+FFFF are not supported when typeform is specified");
            }
            if (characterAttributes != null) {
                throw new IllegalArgumentException("Unicode characters above U+FFFF are not supported when characterAttributes is specified");
            }
            if (interCharacterAttributes != null) {
                throw new IllegalArgumentException("Unicode characters above U+FFFF are not supported when interCharacterAttributes is specified");
            }
        }
        if (typeform != null && typeform.length != textLength) {
            throw new IllegalArgumentException("typeform length must be equal to the text length (number of code points)");
        }
        if (characterAttributes != null && characterAttributes.length != textLength) {
            throw new IllegalArgumentException("characterAttributes length must be equal to text length (number of code points)");
        }
        if (interCharacterAttributes != null && interCharacterAttributes.length != textLength - 1) {
            throw new IllegalArgumentException("interCharacterAttributes length must be equal to text length (number of code points) minus 1");
        }
        try {
            inbuf = Translator.getWideCharBuffer("text-in", textLength).write(text);
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
        WideString outbuf = Translator.getWideCharBuffer("text-out", textLength * OUTLEN_MULTIPLIER);
        IntByReference inlen = new IntByReference(textLength);
        IntByReference outlen = new IntByReference(outbuf.length());
        int[] inputPos = null;
        if (typeform != null) {
            typeform = Arrays.copyOf(typeform, outbuf.length());
        }
        if (characterAttributes != null || interCharacterAttributes != null) {
            inputPos = Translator.getIntegerBuffer("inputpos", textLength * OUTLEN_MULTIPLIER);
        }
        int mode = displayTable.getMode().value();
        if (Louis.getLibrary().lou_translate(this.table, inbuf, inlen, outbuf, outlen, typeform, null, null, inputPos, null, mode) == 0) {
            throw new TranslationException("Unable to complete translation");
        }
        return new TranslationResult(outbuf, outlen, inputPos, characterAttributes, interCharacterAttributes, displayTable);
    }

    public String backTranslate(String text) throws TranslationException {
        WideString inbuf;
        int textLength = WideChar.SIZE == 2 ? text.length() : text.codePoints().toArray().length;
        try {
            inbuf = Translator.getWideCharBuffer("text-in", textLength).write(text);
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
        WideString outbuf = Translator.getWideCharBuffer("text-out", textLength * OUTLEN_MULTIPLIER);
        IntByReference inlen = new IntByReference(textLength);
        IntByReference outlen = new IntByReference(outbuf.length());
        if (Louis.getLibrary().lou_backTranslate(this.table, inbuf, inlen, outbuf, outlen, null, null, null, null, null, 0) == 0) {
            throw new TranslationException("Unable to complete translation");
        }
        try {
            return outbuf.read(outlen.getValue());
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    public byte[] hyphenate(String text) throws TranslationException {
        WideString inbuf;
        int inlen = text.codePoints().toArray().length;
        if (WideChar.SIZE == 2 && inlen != text.length()) {
            throw new IllegalArgumentException("Unicode characters above U+FFFF are not supported");
        }
        try {
            inbuf = Translator.getWideCharBuffer("text-in", inlen).write(text);
        }
        catch (IOException e) {
            throw new RuntimeException("should not happen", e);
        }
        byte[] hyphens = Translator.getByteBuffer("hyphens-out", inlen);
        for (int i = 0; i < inlen; ++i) {
            hyphens[i] = 48;
        }
        Matcher matcher = Pattern.compile("\\p{L}+").matcher(text);
        byte[] wordHyphens = Translator.getByteBuffer("hyphens-word", inlen);
        Louis.LouisLibrary louis = Louis.getLibrary();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (louis.lou_hyphenate(this.table, inbuf.substring(start), end - start, wordHyphens, 0) == 0) {
                throw new TranslationException("Unable to complete hyphenation");
            }
            for (int i = 0; i < end - start; ++i) {
                hyphens[start + i] = wordHyphens[i];
            }
        }
        byte[] hyphenPositions = Translator.readHyphens(new byte[inlen - 1], hyphens);
        matcher = Pattern.compile("[\\p{L}\\p{N}]-(?=[\\p{L}\\p{N}])").matcher(text);
        while (matcher.find()) {
            hyphenPositions[matcher.start() + 1] = 2;
        }
        return hyphenPositions;
    }

    public DisplayTable asDisplayTable() {
        if (this.displayTable == null) {
            this.displayTable = DisplayTable.fromTable(this.table);
        }
        return this.displayTable;
    }

    static WideString getWideCharBuffer(String id, int minCapacity) {
        WideString buffer = Translator.buffers.get().WIDECHAR_BUFFERS.get(id);
        if (buffer == null || buffer.length() < minCapacity) {
            buffer = new WideString(minCapacity * 2);
            Translator.buffers.get().WIDECHAR_BUFFERS.put(id, buffer);
        }
        return buffer;
    }

    private static byte[] getByteBuffer(String id, int minCapacity) {
        byte[] buffer = Translator.buffers.get().BYTE_BUFFERS.get(id);
        if (buffer == null || buffer.length < minCapacity) {
            buffer = new byte[minCapacity * 2];
            Translator.buffers.get().BYTE_BUFFERS.put(id, buffer);
        }
        return buffer;
    }

    private static int[] getIntegerBuffer(String id, int minCapacity) {
        int[] buffer = Translator.buffers.get().INT_BUFFERS.get(id);
        if (buffer == null || buffer.length < minCapacity) {
            buffer = new int[minCapacity * 2];
            Translator.buffers.get().INT_BUFFERS.put(id, buffer);
        }
        return buffer;
    }

    private static byte[] writeHyphens(byte[] hyphenPositions, byte[] buffer) {
        buffer[0] = 48;
        for (int i = 0; i < hyphenPositions.length; ++i) {
            buffer[i + 1] = (byte)(hyphenPositions[i] + 48);
        }
        return buffer;
    }

    private static byte[] readHyphens(byte[] hyphenPositions, byte[] buffer) {
        for (int i = 0; i < hyphenPositions.length; ++i) {
            hyphenPositions[i] = (byte)(buffer[i + 1] - 48);
        }
        return hyphenPositions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{table=" + this.table + "}";
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.table.hashCode();
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != Translator.class) {
            return false;
        }
        Translator that = (Translator)object;
        return this.table.equals(that.table);
    }

    private static class Buffers {
        Map<String, WideString> WIDECHAR_BUFFERS = new HashMap<String, WideString>();
        Map<String, byte[]> BYTE_BUFFERS = new HashMap<String, byte[]>();
        Map<String, int[]> INT_BUFFERS = new HashMap<String, int[]>();

        private Buffers() {
        }
    }
}

