/*
 * Decompiled with CFR 0.152.
 */
package org.liblouis;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.liblouis.Louis;
import org.liblouis.TableResolver;
import org.slf4j.Logger;

class EmbeddedTableResolver
implements TableResolver {
    private final Map<String, URL> tables;
    private final Set<String> tablePaths;
    private final Map<String, URL> aggregatorTables = new HashMap<String, URL>();

    EmbeddedTableResolver(Logger logger) {
        File resourcesJarFile;
        this.tables = new HashMap<String, URL>();
        URL knownResource = Louis.class.getClassLoader().getResource("darwin/liblouis.dylib");
        if (knownResource == null) {
            throw new RuntimeException("resources artifact not on classpath");
        }
        if ("file".equals(knownResource.getProtocol())) {
            resourcesJarFile = Louis.asFile(knownResource).getParentFile().getParentFile();
        } else if ("jar".equals(knownResource.getProtocol())) {
            resourcesJarFile = new File(URI.create(knownResource.toExternalForm().substring(4, knownResource.toExternalForm().indexOf("!/"))));
        } else {
            throw new RuntimeException();
        }
        for (String table : EmbeddedTableResolver.listResources("org/liblouis/resource-files/tables", resourcesJarFile)) {
            this.tables.put(table, this.getClass().getClassLoader().getResource("org/liblouis/resource-files/tables/" + table));
        }
        this.tablePaths = Collections.unmodifiableSet(this.tables.keySet());
        logger.debug("Using default tables");
        logger.trace("Table files: " + this.tablePaths);
    }

    @Override
    public URL resolve(String table, URL base) {
        File f;
        if (this.aggregatorTables.containsValue(base)) {
            base = null;
        }
        if ((base == null || this.tables.containsValue(base)) && this.tables.containsKey(table)) {
            return this.tables.get(table);
        }
        if (base == null && table.contains(",")) {
            if (this.aggregatorTables.containsKey(table)) {
                return this.aggregatorTables.get(table);
            }
            StringBuilder b = new StringBuilder();
            for (String s : table.split(",")) {
                b.append("include ").append(s.replaceAll("\\\\", "\\\\\\\\").replaceAll(" ", "\\\\s")).append('\n');
            }
            ByteArrayInputStream in = new ByteArrayInputStream(b.toString().getBytes(StandardCharsets.UTF_8));
            try {
                File f2 = File.createTempFile("liblouis-java-", ".tbl");
                f2.delete();
                Files.copy(in, f2.toPath(), new CopyOption[0]);
                f2.deleteOnExit();
                URL u = Louis.asURL(f2);
                this.aggregatorTables.put(table, u);
                return u;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (base != null && base.toString().startsWith("file:")) {
            File f3;
            File file = f3 = base.toString().endsWith("/") ? new File(Louis.asFile(base), table) : new File(Louis.asFile(base).getParentFile(), table);
            if (f3.exists()) {
                return Louis.asURL(f3);
            }
        } else if (base == null && (f = new File(table)).exists()) {
            return Louis.asURL(f);
        }
        return null;
    }

    @Override
    public Set<String> list() {
        return this.tablePaths;
    }

    private static Iterable<String> listResources(String directory, Class<?> context) {
        return EmbeddedTableResolver.listResources(directory, Louis.asFile(context.getProtectionDomain().getCodeSource().getLocation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterable<String> listResources(String directory, File jarFile) {
        FileSystem fs;
        if (!jarFile.exists()) {
            throw new RuntimeException();
        }
        if (jarFile.isDirectory()) {
            File d = new File(jarFile, directory);
            if (!d.exists()) {
                throw new RuntimeException("directory does not exist");
            }
            if (!d.isDirectory()) {
                throw new RuntimeException("is not a directory");
            }
            ArrayList<String> resources = new ArrayList<String>();
            for (File f : d.listFiles()) {
                resources.add(f.getName() + (f.isDirectory() ? "/" : ""));
            }
            return resources;
        }
        try {
            fs = FileSystems.newFileSystem(URI.create("jar:" + jarFile.toURI()), Collections.emptyMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            BasicFileAttributes a;
            Path d = fs.getPath("/" + directory, new String[0]);
            try {
                a = Files.getFileAttributeView(d, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            }
            catch (NoSuchFileException e) {
                throw new RuntimeException("directory does not exist");
            }
            catch (FileSystemNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!a.isDirectory()) {
                throw new RuntimeException("is not a directory");
            }
            final ArrayList<String> resources = new ArrayList<String>();
            try {
                Files.walkFileTree(d, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path f, BasicFileAttributes _) throws IOException {
                        resources.add("" + f.getFileName());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (NoSuchFileException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            try {
                fs.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

