package org.libj.util;

public enum CharacterClassEnum {
  ASCII("ASCII", new int[][] {{0, 1, 2}, {0}}),
  ALNUM("Alnum", new int[][] {{0, 1, 2}, {1, 2}, {1}}),
  ALPHA("Alpha", new int[][] {{0, 1, 2}, {1, 2}, {2}}),
  BLANK("Blank", new int[][] {{3}}),
  CNTRL("Cntrl", new int[][] {{4}}),
  DIGIT("Digit", new int[][] {{5}}),
  GRAPH("Graph", new int[][] {{6}}),
  INGREEK("InGreek", new int[][] {{7, 8, 9}, {7}}),
  ISALPHABETIC("IsAlphabetic", new int[][] {{7, 8, 9}, {8, 9}, {8}}),
  ISLATIN("IsLatin", new int[][] {{7, 8, 9}, {8, 9}, {9}}),
  LOWER("Lower", new int[][] {{10, 11}, {10}}),
  LU("Lu", new int[][] {{10, 11}, {11}}),
  PRINT("Print", new int[][] {{12, 13}, {12}}),
  PUNCT("Punct", new int[][] {{12, 13}, {13}}),
  SC("Sc", new int[][] {{14, 15}, {14}}),
  SPACE("Space", new int[][] {{14, 15}, {15}}),
  UPPER("Upper", new int[][] {{16}}),
  XDIGIT("XDigit", new int[][] {{17}}),
  JAVALOWERCASE("javaLowerCase", new int[][] {{18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {18}}),
  JAVAMIRRORED("javaMirrored", new int[][] {{18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {19}}),
  JAVAUPPERCASE("javaUpperCase", new int[][] {{18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {20}}),
  JAVAWHITESPACE("javaWhitespace", new int[][] {{18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {18, 19, 20, 21}, {21}});

  private static final int[] root = new int[] {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
  private final java.lang.String token;
  final int[][] tree;

  CharacterClassEnum(final java.lang.String token, final int[][] tree) {
    this.token = token;
    this.tree = tree;
  }

  public static CharacterClassEnum findNext(final CharacterClassEnum previous, final int position, final char ch) {
    if (position == 0) {
      final int index = org.openjax.codegen.radixtree.RadixTreeEnumUtil.binarySearch(CharacterClassEnum.values(), CharacterClassEnum.root, ch, position);
      return index < 0 ? null : CharacterClassEnum.values()[index];
    }

    if (position <= previous.tree.length) {
      final int[] tree = previous.tree[position - 1];
      final int index = org.openjax.codegen.radixtree.RadixTreeEnumUtil.binarySearch(CharacterClassEnum.values(), tree, ch, position);
      return index < 0 ? null : CharacterClassEnum.values()[tree[index]];
    }

    return previous.token.length() <= position || previous.token.charAt(position) != ch ? null : previous;
  }

  @java.lang.Override
  public java.lang.String toString() {
    return token;
  }
}