/*
 * Decompiled with CFR 0.152.
 */
package org.libj.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TestExecutorService
implements ExecutorService {
    protected static final ConcurrentHashMap<Thread, Throwable> exception = new ConcurrentHashMap();
    protected ExecutorService target;
    private final ArrayList<Thread> threads = new ArrayList();

    public TestExecutorService(ExecutorService target) {
        this.target = Objects.requireNonNull(target);
    }

    @Override
    public void execute(Runnable command) {
        this.target.execute(() -> {
            this.threads.add(Thread.currentThread());
            command.run();
        });
    }

    @Override
    public void shutdown() {
        this.target.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.target.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.target.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.target.isTerminated();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.target.submit(() -> {
            this.threads.add(Thread.currentThread());
            return task.call();
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.target.submit(() -> {
            this.threads.add(Thread.currentThread());
            task.run();
        }, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.target.submit(() -> {
            this.threads.add(Thread.currentThread());
            task.run();
        });
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>(tasks);
        int i$ = callables.size();
        for (int i = 0; i < i$; ++i) {
            final Callable<T> task = callables.get(i);
            callables.set(i, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    TestExecutorService.this.threads.add(Thread.currentThread());
                    return task.call();
                }
            });
        }
        return this.target.invokeAll(callables);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>(tasks);
        int i$ = callables.size();
        for (int i = 0; i < i$; ++i) {
            final Callable<T> task = callables.get(i);
            callables.set(i, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    TestExecutorService.this.threads.add(Thread.currentThread());
                    return task.call();
                }
            });
        }
        return this.target.invokeAll(callables, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>(tasks);
        int i$ = callables.size();
        for (int i = 0; i < i$; ++i) {
            final Callable<T> task = callables.get(i);
            callables.set(i, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    TestExecutorService.this.threads.add(Thread.currentThread());
                    return task.call();
                }
            });
        }
        return this.target.invokeAny(callables);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<Callable<T>> callables = new ArrayList<Callable<T>>(tasks);
        int i$ = callables.size();
        for (int i = 0; i < i$; ++i) {
            final Callable<T> task = callables.get(i);
            callables.set(i, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    TestExecutorService.this.threads.add(Thread.currentThread());
                    return task.call();
                }
            });
        }
        return this.target.invokeAny(callables, timeout, unit);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.target.awaitTermination(timeout, unit);
        int i$ = this.threads.size();
        for (int i = 0; i < i$; ++i) {
            Throwable t;
            Thread thread = this.threads.get(i);
            if (thread == null || (t = exception.get(thread)) == null) continue;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            InterruptedException e = new InterruptedException();
            e.initCause(t);
            throw e;
        }
        return result;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                exception.put(t, e);
            }
        });
    }
}

