/*
 * Decompiled with CFR 0.152.
 */
package org.libj.test;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;

public final class TestAide {
    private static boolean inSurefireTestInited;
    private static boolean inSurefireTest;
    private static boolean inCiTestInited;
    private static boolean inCiTest;
    private static boolean inDebugInited;
    private static boolean inDebug;

    public static boolean isInSurefireTest() {
        if (inSurefireTestInited) {
            return inSurefireTest;
        }
        inSurefireTest = System.getProperty("sun.java.command").contains("org.apache.maven.surefire") || System.getProperty("surefire.test.class.path") != null;
        inSurefireTestInited = true;
        return inSurefireTest;
    }

    public static boolean isInCiTest() {
        if (inCiTestInited) {
            return inCiTest;
        }
        String property = System.getenv("CI");
        inCiTest = property != null && !"false".equals(property);
        inCiTestInited = true;
        return inCiTest;
    }

    public static boolean isInDebug(boolean waitSysIn) {
        if (!inDebugInited) {
            inDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
            inDebugInited = true;
        }
        if (!inDebug || !waitSysIn) {
            return inDebug;
        }
        try {
            System.out.flush();
            System.err.flush();
            System.err.println(">> TestAide.isInDebug(true) = true");
            System.in.read();
            return inDebug;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isInDebug() {
        return TestAide.isInDebug(false);
    }

    public static void printRuntimeParameters(PrintStream ps) {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        int i$ = arguments.size();
        if (i$ > 0) {
            if (arguments instanceof RandomAccess) {
                int i = 0;
                do {
                    ps.println(arguments.get(i));
                } while (++i < i$);
            } else {
                Iterator<String> i = arguments.iterator();
                do {
                    ps.println(i.next());
                } while (i.hasNext());
            }
        }
    }

    public static void printStackTrace(PrintStream out, Throwable t) {
        TestAide.printStackTrace(out, t, Collections.newSetFromMap(new IdentityHashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(PrintStream out, Throwable t, Set<Throwable> visited) {
        Throwable throwable = t;
        synchronized (throwable) {
            if (visited.add(t)) {
                StackTraceElement stackTraceElement;
                out.println(t.toString());
                StackTraceElement[] stackTraceElements = t.getStackTrace();
                Serializable[] serializableArray = stackTraceElements;
                int n = serializableArray.length;
                for (int i = 0; !(i >= n || "runReflectiveCall".equals((stackTraceElement = serializableArray[i]).getMethodName()) && stackTraceElement.getClassName().startsWith("org.junit.runners.")); ++i) {
                    out.println("\tat " + stackTraceElement);
                }
                for (Serializable serializable : t.getSuppressed()) {
                    out.print("\nSuppressed: ");
                    TestAide.printStackTrace(out, (Throwable)serializable, visited);
                }
                Throwable cause = t.getCause();
                if (cause != null) {
                    out.print("Caused by: ");
                    TestAide.printStackTrace(out, t, visited);
                }
            }
        }
    }

    private TestAide() {
    }
}

