/*
 * Decompiled with CFR 0.152.
 */
package org.libj.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class SimpleNamespaceContext
implements NamespaceContext,
Serializable {
    private static final List<String> xmlns = Collections.singletonList("xmlns");
    private static final List<String> xml = Collections.singletonList("xml");
    private final Map<String, String> prefixToNamespaceURI;
    private final Map<String, List<String>> namespaceUriToPrefix = new HashMap<String, List<String>>();

    public SimpleNamespaceContext(Map<String, String> prefixToNamespaceURI) {
        this.prefixToNamespaceURI = prefixToNamespaceURI;
        if (prefixToNamespaceURI.size() > 0) {
            for (Map.Entry<String, String> entry : prefixToNamespaceURI.entrySet()) {
                List<String> prefixes = this.namespaceUriToPrefix.get(entry.getValue());
                if (prefixes == null) {
                    prefixes = new ArrayList<String>();
                    this.namespaceUriToPrefix.put(entry.getValue(), prefixes);
                }
                prefixes.add(entry.getKey());
            }
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixToNamespaceURI.get(prefix);
    }

    @Override
    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return "xmlns";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return "xml";
        }
        List<String> prefixes = this.namespaceUriToPrefix.get(uri);
        return prefixes == null ? null : prefixes.get(0);
    }

    @Override
    public Iterator<String> getPrefixes(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
            return xmlns.iterator();
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return xml.iterator();
        }
        final List<String> prefixes = this.namespaceUriToPrefix.get(uri);
        return prefixes == null ? null : new Iterator<String>(){
            private final Iterator<String> iterator;
            {
                this.iterator = prefixes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public String next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

