/*
 * Decompiled with CFR 0.152.
 */
package org.libj.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Pattern;

public class JUnitUtil {
    private static final URL[] emptyResources = new URL[0];

    private static URL[] getResources(String path, Pattern pattern, ClassLoader classLoader, BufferedReader reader, int depth) throws IOException {
        String fileName = reader.readLine();
        if (fileName == null) {
            return new URL[depth];
        }
        String name = path + fileName;
        if (pattern != null && !pattern.matcher(name).matches()) {
            return JUnitUtil.getResources(path, pattern, classLoader, reader, depth);
        }
        URL[] urls = JUnitUtil.getResources(path, pattern, classLoader, reader, depth + 1);
        urls[depth] = classLoader.getResource(name);
        return urls;
    }

    public static URL[] getResources(String path, String regex, ClassLoader classLoader) throws IOException {
        InputStream in = classLoader.getResourceAsStream(path);
        if (in == null) {
            return emptyResources;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            URL[] uRLArray = JUnitUtil.getResources(path.isEmpty() || path.endsWith("/") ? path : path + "/", regex == null ? null : Pattern.compile(regex), classLoader, reader, 0);
            return uRLArray;
        }
    }

    public static URL[] getResources(String path, ClassLoader classLoader) throws IOException {
        return JUnitUtil.getResources(path, null, classLoader);
    }

    public static URL[] getResources(String path, String regex) throws IOException {
        return JUnitUtil.getResources(path, regex, ClassLoader.getSystemClassLoader());
    }

    public static URL[] getResources(String path) throws IOException {
        return JUnitUtil.getResources(path, null, ClassLoader.getSystemClassLoader());
    }

    public static URL[] sortBySize(URL ... resources) {
        Arrays.sort(resources, (o1, o2) -> {
            try {
                return Long.compare(new File(o1.toURI()).length(), new File(o2.toURI()).length());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
        return resources;
    }

    private JUnitUtil() {
    }
}

