/*
 * Decompiled with CFR 0.152.
 */
package org.libj.test;

import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.libj.test.SimpleNamespaceContext;
import org.openjax.xml.dom.DOMStyle;
import org.openjax.xml.dom.DOMs;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DOMDifferenceEngine;

public final class AssertXml {
    private static final String diffPackageName = Comparison.class.getPackage().getName();
    private static final Pattern ATTR_NAME_PATTERN = Pattern.compile("/([^@])");
    private static final Pattern ATTR_MATCH_PATTERN = Pattern.compile("^.*/@[:a-z]+$");
    private final NamespaceContext namespaceContext;
    private final Element control;
    private final Element test;

    public static AssertXml compare(Element control, Element test) {
        HashMap<String, String> prefixToNamespaceURI = new HashMap<String, String>();
        prefixToNamespaceURI.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        NamedNodeMap attributes = control.getAttributes();
        int i$ = attributes.getLength();
        for (int i = 0; i < i$; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI()) || !"xmlns".equals(attribute.getPrefix())) continue;
            prefixToNamespaceURI.put(attribute.getLocalName(), attribute.getNodeValue());
        }
        return new AssertXml(new SimpleNamespaceContext(prefixToNamespaceURI), control, test);
    }

    private AssertXml(NamespaceContext namespaceContext, Element control, Element test) {
        if (!control.getPrefix().equals(test.getPrefix())) {
            throw new IllegalArgumentException("Prefixes of control and test elements must be the same: \"" + control.getPrefix() + "\" != \"" + test.getPrefix() + "\"");
        }
        this.namespaceContext = namespaceContext;
        this.control = control;
        this.test = test;
    }

    private XPath newXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(this.namespaceContext);
        return xPath;
    }

    private AssertXml addAttr(Element element, String xpath, String name, String value) throws XPathExpressionException {
        XPathExpression expression = this.newXPath().compile(xpath);
        NodeList nodes = (NodeList)expression.evaluate(element, XPathConstants.NODESET);
        int i$ = nodes.getLength();
        for (int i = 0; i < i$; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) {
                throw new UnsupportedOperationException("Only support addition of attributes to elements");
            }
            Element target = (Element)node;
            int colon = name.indexOf(58);
            String namespaceURI = colon == -1 ? node.getNamespaceURI() : node.getOwnerDocument().lookupNamespaceURI(name.substring(0, colon));
            target.setAttributeNS(namespaceURI, name, value);
        }
        return this;
    }

    public AssertXml addAttrToControl(String xpath, String name, String value) throws XPathExpressionException {
        return this.addAttr(this.control, xpath, name, value);
    }

    public AssertXml addAttrToTest(String xpath, String name, String value) throws XPathExpressionException {
        return this.addAttr(this.test, xpath, name, value);
    }

    private AssertXml remove(Element element, String ... xpaths) throws XPathExpressionException {
        for (String xpath : xpaths) {
            XPathExpression expression = this.newXPath().compile(xpath);
            NodeList nodes = (NodeList)expression.evaluate(element, XPathConstants.NODESET);
            int i$ = nodes.getLength();
            for (int i = 0; i < i$; ++i) {
                Node node = nodes.item(i);
                if (node instanceof Attr) {
                    Attr attribute = (Attr)node;
                    attribute.getOwnerElement().removeAttributeNode(attribute);
                    continue;
                }
                node.getParentNode().removeChild(node);
            }
        }
        return this;
    }

    public AssertXml removeFromControl(String ... xpaths) throws XPathExpressionException {
        return this.remove(this.control, xpaths);
    }

    public AssertXml removeFromTest(String ... xpaths) throws XPathExpressionException {
        return this.remove(this.test, xpaths);
    }

    private AssertXml replaceAttr(Element element, String xpath, String name, String value) throws XPathExpressionException {
        XPathExpression expression = this.newXPath().compile(xpath);
        NodeList nodes = (NodeList)expression.evaluate(element, XPathConstants.NODESET);
        int i$ = nodes.getLength();
        for (int i = 0; i < i$; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Attr) {
                Attr attribute = (Attr)node;
                if (name == null) {
                    attribute.setValue(value);
                    continue;
                }
                int colon = name.indexOf(58);
                String namespaceURI = colon == -1 ? attribute.getNamespaceURI() : attribute.getOwnerDocument().lookupNamespaceURI(name.substring(0, colon));
                Element owner = attribute.getOwnerElement();
                owner.removeAttributeNode(attribute);
                owner.setAttributeNS(namespaceURI, name, value);
                continue;
            }
            throw new UnsupportedOperationException("Only support replacement of attribute values");
        }
        return this;
    }

    public AssertXml replaceAttrInControl(String xpath, String name, String value) throws XPathExpressionException {
        return this.replaceAttr(this.control, xpath, name, value);
    }

    public AssertXml replaceAttrInTest(String xpath, String name, String value) throws XPathExpressionException {
        return this.replaceAttr(this.test, xpath, name, value);
    }

    public AssertXml replaceAttrInControl(String xpath, String value) throws XPathExpressionException {
        return this.replaceAttr(this.control, xpath, null, value);
    }

    public AssertXml replaceAttrInTest(String xpath, String value) throws XPathExpressionException {
        return this.replaceAttr(this.test, xpath, null, value);
    }

    public void assertEqual() {
        this.assertEqual(null, false);
    }

    public void assertEqual(String message) {
        this.assertEqual(message, false);
    }

    public void assertEqual(boolean filterStacktrace) {
        this.assertEqual(null, filterStacktrace);
    }

    public void assertEqual(final String message, final boolean filterStacktrace) {
        final String prefix = this.control.getPrefix();
        final String controlXml = DOMs.domToString((Node)this.control, (DOMStyle[])new DOMStyle[]{DOMStyle.INDENT, DOMStyle.INDENT_ATTRS});
        final String testXml = DOMs.domToString((Node)this.test, (DOMStyle[])new DOMStyle[]{DOMStyle.INDENT, DOMStyle.INDENT_ATTRS});
        Source controlSource = Input.fromString((String)controlXml).build();
        Source testSource = Input.fromString((String)testXml).build();
        DOMDifferenceEngine diffEngine = new DOMDifferenceEngine();
        diffEngine.addDifferenceListener(new ComparisonListener(){

            public void comparisonPerformed(Comparison comparison, ComparisonResult result) {
                String xPath = comparison.getControlDetails().getXPath();
                if (xPath == null) {
                    return;
                }
                String controlXPath = ATTR_NAME_PATTERN.matcher(xPath).replaceAll("/" + prefix + ":$1");
                if (ATTR_MATCH_PATTERN.matcher(controlXPath).matches() || controlXPath.contains("text()")) {
                    return;
                }
                try {
                    Assert.assertEquals((String)message, (Object)controlXml, (Object)testXml);
                }
                catch (ComparisonFailure e) {
                    if (filterStacktrace) {
                        StackTraceElement[] stackTrace = e.getStackTrace();
                        int i = 3;
                        while (i < stackTrace.length && stackTrace[i++].getClassName().startsWith(diffPackageName)) {
                        }
                        int length = stackTrace.length - ++i;
                        StackTraceElement[] filtered = new StackTraceElement[length];
                        System.arraycopy(stackTrace, i, filtered, 0, length);
                        e.setStackTrace(filtered);
                    }
                    throw e;
                }
                Assert.fail((String)comparison.toString());
            }
        });
        diffEngine.compare(controlSource, testSource);
    }
}

