/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.libj.sql.Audit;
import org.libj.sql.AuditUtil;
import org.libj.sql.DelegateStatement;
import org.libj.sql.ResultSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditStatement
extends Audit
implements DelegateStatement {
    private static final Logger logger = LoggerFactory.getLogger(AuditStatement.class);
    private final Statement target;
    private ArrayList<String> batchLogs;

    public static SQLException close(Statement statement) {
        try {
            if (!statement.isClosed()) {
                statement.close();
            }
            return null;
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(statement.getClass().getName() + ".close(): " + e.getMessage());
            }
            return e;
        }
    }

    public static Statement wrapIfDebugEnabled(Statement target) {
        return logger.isDebugEnabled() ? new AuditStatement(target) : target;
    }

    public AuditStatement(Statement target) {
        this.target = target;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    protected long getLogTimestamp(boolean enabled) {
        return enabled ? System.currentTimeMillis() : -1L;
    }

    protected int getLogResultSetSize(boolean enabled, ResultSet resultSet) throws SQLException {
        return enabled ? ResultSets.getSize(resultSet) : -1;
    }

    protected String log(boolean enabled, String method, boolean newLine, StringBuilder sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, Object result, long time) throws SQLException {
        if (!enabled) {
            return null;
        }
        StringBuilder b = AuditUtil.log(this, method, this.getConnection(), newLine, sql);
        if (autoGeneratedKeys != Integer.MIN_VALUE) {
            b.append(", ").append(autoGeneratedKeys);
        } else if (columnIndexes != null) {
            for (int columnIndex : columnIndexes) {
                b.append(", ").append(columnIndex);
            }
        } else if (columnNames != null) {
            for (String columnName : columnNames) {
                b.append(", ").append(columnName);
            }
        }
        b.append("\n)");
        if (result != null) {
            AuditUtil.withResult(b, result, time);
        }
        return b.toString();
    }

    @Override
    public Statement getTarget() {
        return this.target;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long time = -1L;
        int size = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.QUERY, sql, this.log(this.isTraceEnabled(), "executeQuery", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            ResultSet resultSet = this.getTarget().executeQuery(sql);
            size = this.getLogResultSetSize(isDebugEnabled, resultSet);
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            this.debug(Audit.StatementType.QUERY, sql, this.log(isDebugEnabled, "executeQuery", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, size, time), exception);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long time = -1L;
        int count = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.UPDATE, sql, this.log(this.isTraceEnabled(), "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            int n = count = this.getTarget().executeUpdate(sql);
            return n;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            this.debug(Audit.StatementType.UPDATE, sql, this.log(isDebugEnabled, "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, count, time), exception);
        }
    }

    @Override
    public void close() throws SQLException {
        block4: {
            try {
                Statement target = this.getTarget();
                if (!target.isClosed()) {
                    target.close();
                }
                if (this.batchLogs != null) {
                    this.batchLogs.clear();
                    this.batchLogs = null;
                }
            }
            catch (SQLException e) {
                if ("Connection is closed.".equals(e.getMessage())) break block4;
                throw e;
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean bl;
        long time = -1L;
        Boolean result = null;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.MULTIPLE, sql, this.log(this.isTraceEnabled(), "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            result = this.getTarget().execute(sql);
            bl = result;
        }
        catch (Throwable t) {
            try {
                exception = t;
                throw t;
            }
            catch (Throwable throwable) {
                this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, result, time), exception);
                throw throwable;
            }
        }
        this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, null, result, time), exception);
        return bl;
    }

    protected void logAddBatch(boolean enabled, String sql) {
        if (!enabled) {
            return;
        }
        if (this.batchLogs == null) {
            this.batchLogs = new ArrayList();
        }
        this.batchLogs.add(sql);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.logAddBatch(this.isDebugEnabled(), sql);
        this.getTarget().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getTarget().clearBatch();
        if (this.batchLogs != null) {
            this.batchLogs.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        long time = -1L;
        int[] count = null;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            StringBuilder sql = this.logExecuteBatch(null, -1L);
            this.trace(Audit.StatementType.MULTIPLE, sql.toString(), this.log(this.isTraceEnabled(), "executeBatch", false, sql, Integer.MIN_VALUE, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            nArray = count = this.getTarget().executeBatch();
        }
        catch (Throwable t) {
            try {
                exception = t;
                throw t;
            }
            catch (Throwable throwable) {
                StringBuilder sql = this.logExecuteBatch(count, time);
                if ("[])".equals(sql.toString())) {
                    this.logExecuteBatch(count, time);
                }
                this.debug(Audit.StatementType.MULTIPLE, sql.toString(), this.log(isDebugEnabled, "executeBatch", false, sql, Integer.MIN_VALUE, null, null, null, -1L), exception);
                this.logExecuteBatch(count, time);
                throw throwable;
            }
        }
        StringBuilder sql = this.logExecuteBatch(count, time);
        if ("[])".equals(sql.toString())) {
            this.logExecuteBatch(count, time);
        }
        this.debug(Audit.StatementType.MULTIPLE, sql.toString(), this.log(isDebugEnabled, "executeBatch", false, sql, Integer.MIN_VALUE, null, null, null, -1L), exception);
        this.logExecuteBatch(count, time);
        return nArray;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long time = -1L;
        int count = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.UPDATE, sql, this.log(this.isTraceEnabled(), "executeUpdate", true, new StringBuilder(sql), autoGeneratedKeys, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            int n = count = this.getTarget().executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            this.debug(Audit.StatementType.UPDATE, sql, this.log(isDebugEnabled, "executeUpdate", true, new StringBuilder(sql), autoGeneratedKeys, null, null, count, time), exception);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long time = -1L;
        int count = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.UPDATE, sql, this.log(this.isTraceEnabled(), "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, columnIndexes, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            int n = count = this.getTarget().executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            this.debug(Audit.StatementType.UPDATE, sql, this.log(isDebugEnabled, "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, columnIndexes, null, count, time), exception);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long time = -1L;
        int count = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.UPDATE, sql, this.log(this.isTraceEnabled(), "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, null, columnNames, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            int n = count = this.getTarget().executeUpdate(sql, columnNames);
            return n;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            this.debug(Audit.StatementType.UPDATE, sql, this.log(isDebugEnabled, "executeUpdate", true, new StringBuilder(sql), Integer.MIN_VALUE, null, columnNames, count, time), exception);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean bl;
        long time = -1L;
        Boolean result = null;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.MULTIPLE, sql, this.log(this.isTraceEnabled(), "execute", true, new StringBuilder(sql), autoGeneratedKeys, null, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            result = this.getTarget().execute(sql, autoGeneratedKeys);
            bl = result;
        }
        catch (Throwable t) {
            try {
                exception = t;
                throw t;
            }
            catch (Throwable throwable) {
                this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), autoGeneratedKeys, null, null, result, time), exception);
                throw throwable;
            }
        }
        this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), autoGeneratedKeys, null, null, result, time), exception);
        return bl;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean bl;
        long time = -1L;
        Boolean result = null;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.MULTIPLE, sql, this.log(this.isTraceEnabled(), "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, columnIndexes, null, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            result = this.getTarget().execute(sql, columnIndexes);
            bl = result;
        }
        catch (Throwable t) {
            try {
                exception = t;
                throw t;
            }
            catch (Throwable throwable) {
                this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, columnIndexes, null, result, time), exception);
                throw throwable;
            }
        }
        this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, columnIndexes, null, result, time), exception);
        return bl;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean bl;
        long time = -1L;
        Boolean result = null;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            this.trace(Audit.StatementType.MULTIPLE, sql, this.log(this.isTraceEnabled(), "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, columnNames, null, -1L));
            time = this.getLogTimestamp(isDebugEnabled);
            result = this.getTarget().execute(sql, columnNames);
            bl = result;
        }
        catch (Throwable t) {
            try {
                exception = t;
                throw t;
            }
            catch (Throwable throwable) {
                this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, columnNames, result, time), exception);
                throw throwable;
            }
        }
        this.debug(Audit.StatementType.MULTIPLE, sql, this.log(isDebugEnabled, "execute", true, new StringBuilder(sql), Integer.MIN_VALUE, null, columnNames, result, time), exception);
        return bl;
    }

    public boolean equals(Object obj) {
        return this.getTarget().equals(obj);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    protected StringBuilder logExecuteBatch(int[] count, long time) throws SQLException {
        StringBuilder b = new StringBuilder();
        if (!this.toStringBatch(b, count, true)) {
            b.setLength(1);
        }
        b.append(')');
        if (count != null) {
            b.append(' ').append(System.currentTimeMillis() - time).append("ms");
        }
        return b;
    }

    protected boolean toStringBatch(StringBuilder b, int[] count, boolean indent) {
        if (this.batchLogs == null) {
            return false;
        }
        b.append("[\n");
        int size = this.batchLogs.size();
        if (count != null) {
            if (indent) {
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        b.append('\n');
                    }
                    b.append("  ").append(this.batchLogs.get(i)).append(" -> ").append(count[i]);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        b.append('\n');
                    }
                    b.append(this.batchLogs.get(i)).append(" -> ").append(count[i]);
                }
            }
        } else if (indent) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append("  ").append(this.batchLogs.get(i));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append(this.batchLogs.get(i));
            }
        }
        b.append("\n]");
        return true;
    }

    public String toString() {
        if (this.batchLogs == null) {
            return this.getTarget().toString();
        }
        StringBuilder b = new StringBuilder();
        this.toStringBatch(b, null, false);
        return b.toString();
    }
}

