/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.libj.lang.Hexadecimal;
import org.libj.sql.Audit;
import org.libj.sql.AuditStatement;
import org.libj.sql.DateTimes;
import org.libj.sql.DelegatePreparedStatement;
import org.libj.sql.ResultSets;
import org.libj.util.DecimalFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditPreparedStatement
extends AuditStatement
implements DelegatePreparedStatement {
    static final Logger logger = LoggerFactory.getLogger(AuditPreparedStatement.class);
    protected static final String NULL = "NULL";
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter timeFormat = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MILLI_OF_SECOND, 0, 6, true).toFormatter();
    private static final DateTimeFormatter timestampFormat = new DateTimeFormatterBuilder().append(dateFormat).appendLiteral(' ').append(timeFormat).toFormatter();
    private static final ThreadLocal<DecimalFormat> numberFormat = DecimalFormatter.createDecimalFormat((String)"###############.###############;-###############.###############");
    private final String sql;
    private ArrayList<HashMap<Object, Object>> parameterMaps;
    private boolean addParameterMap = true;

    private static String toString(Object value) {
        Closeable in;
        if (value == NULL) {
            return NULL;
        }
        if (value instanceof byte[]) {
            return "X'" + new Hexadecimal((byte[])value) + "'";
        }
        if (value instanceof InputStream) {
            in = (InputStream)value;
            try {
                int by = ((InputStream)in).read();
                if (by == -1) {
                    try {
                        ((InputStream)in).reset();
                    }
                    catch (IOException ignore) {
                        return value.toString();
                    }
                }
                if (((InputStream)in).markSupported()) {
                    ((InputStream)in).mark(Integer.MAX_VALUE);
                }
                if ((by = ((InputStream)in).read()) != -1) {
                    int len;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(by);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) != -1) {
                        out.write(buf, 0, len);
                    }
                    if (((InputStream)in).markSupported()) {
                        ((InputStream)in).reset();
                    }
                    return "X'" + new Hexadecimal(out.toByteArray()) + "'";
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (value instanceof Reader) {
            in = (Reader)value;
            try {
                int ch = ((Reader)in).read();
                if (ch == -1) {
                    try {
                        ((Reader)in).reset();
                    }
                    catch (IOException ignore) {
                        return value.toString();
                    }
                }
                if (((Reader)in).markSupported()) {
                    ((Reader)in).mark(Integer.MAX_VALUE);
                }
                if ((ch = ((Reader)in).read()) != -1) {
                    int len;
                    StringBuilder b = new StringBuilder();
                    b.append('\'').append(ch);
                    char[] buf = new char[1024];
                    while ((len = ((Reader)in).read(buf)) != -1) {
                        b.append(buf, 0, len);
                    }
                    if (((Reader)in).markSupported()) {
                        ((Reader)in).reset();
                    }
                    b.append('\'');
                    return b.toString();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (value instanceof Date) {
            return "'" + ((Date)value).toLocalDate().format(dateFormat) + "'";
        }
        if (value instanceof Time) {
            return "'" + DateTimes.toLocalTime((Time)value).format(timeFormat) + "'";
        }
        if (value instanceof Timestamp) {
            return "'" + ((Timestamp)value).toLocalDateTime().format(timestampFormat) + "'";
        }
        if (value instanceof String || value instanceof URL) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return numberFormat.get().format(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "TRUE" : "FALSE";
        }
        if (value == null) {
            return "?";
        }
        if ("oracle.sql.INTERVALDS".equals(value.getClass().getName())) {
            String str = value.toString();
            return "'" + str.substring(str.indexOf(32) + 1) + "'";
        }
        return value.toString();
    }

    private static int writeParameter(StringBuilder b, int start, int end, Object obj) {
        int len = b.length();
        b.replace(start, end, AuditPreparedStatement.toString(obj));
        return b.length() - len;
    }

    private static StringBuilder toString(String sql, Map<Object, Object> parameterMap) {
        int index = 0;
        boolean escaped = false;
        char inQuote = '\u0000';
        int colon = -1;
        boolean namedQuoted = false;
        StringBuilder b = new StringBuilder(sql);
        for (int i = 0; i < b.length(); ++i) {
            char ch = b.charAt(i);
            if (colon != -1) {
                if (colon == i - 1 && ch == '\"') {
                    namedQuoted = true;
                    continue;
                }
                if ((ch != '\"' || !namedQuoted) && (ch == '#' || ch == '$' || ch >= '0' && '9' >= ch || ch >= '@' && 'Z' >= ch || ch == '_' || ch >= 'a' && 'z' >= ch)) continue;
                i += AuditPreparedStatement.writeParameter(b, colon, i, parameterMap.get(b.substring(colon + 1, i)));
                colon = -1;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (inQuote == '\u0000' || !escaped) {
                if (ch == '\'' || ch == '\"') {
                    inQuote = inQuote == ch ? (char)'\u0000' : ch;
                } else if (inQuote == '\u0000') {
                    if (ch == ':') {
                        colon = i;
                    } else if (ch == '?') {
                        i += AuditPreparedStatement.writeParameter(b, i, i + 1, parameterMap.get(++index));
                    }
                }
            }
            escaped = false;
        }
        return b;
    }

    public static PreparedStatement wrapIfDebugEnabled(PreparedStatement target, String sql) {
        return logger.isDebugEnabled() ? new AuditPreparedStatement(target, sql) : target;
    }

    public AuditPreparedStatement(PreparedStatement target, String sql) {
        super(target);
        this.sql = sql;
    }

    @Override
    protected boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    @Override
    protected boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    @Override
    protected void trace(Audit.StatementType statementType, String sql, String detail) {
        if (detail != null) {
            logger.trace(detail);
        }
    }

    @Override
    protected void debug(Audit.StatementType statementType, String sql, String detail, Throwable exception) {
        if (detail != null) {
            logger.debug(detail);
        }
    }

    protected void addParameter(boolean enabled, Object key, Object value) {
        HashMap<Object, Object> parameterMap;
        ArrayList<HashMap<Object, Object>> parameterMaps = this.parameterMaps;
        if (parameterMaps == null) {
            parameterMaps = this.parameterMaps = new ArrayList();
        }
        if (this.addParameterMap) {
            parameterMap = new HashMap();
            parameterMaps.add(parameterMap);
            this.addParameterMap = false;
        } else {
            parameterMap = parameterMaps.get(parameterMaps.size() - 1);
        }
        parameterMap.put(key, value);
    }

    @Override
    protected void logAddBatch(boolean enabled, String sql) {
        if (enabled) {
            this.addParameterMap = true;
        }
    }

    @Override
    public PreparedStatement getTarget() {
        return (PreparedStatement)super.getTarget();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        PreparedStatement statement = this.getTarget();
        int size = -1;
        long time = -1L;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            StringBuilder sql = this.toStringBuilder();
            this.trace(Audit.StatementType.QUERY, sql.toString(), this.log(this.isTraceEnabled(), "executeQuery", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, null, -1L));
            if (isDebugEnabled) {
                time = System.currentTimeMillis();
            }
            ResultSet resultSet = statement.executeQuery();
            if (isDebugEnabled) {
                size = ResultSets.getSize(resultSet);
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            StringBuilder sql = this.toStringBuilder();
            this.debug(Audit.StatementType.QUERY, sql.toString(), this.log(isDebugEnabled, "executeQuery", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, size, time), exception);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        long time = -1L;
        int count = -1;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            StringBuilder sql = this.toStringBuilder();
            this.trace(Audit.StatementType.UPDATE, sql.toString(), this.log(this.isTraceEnabled(), "executeUpdate", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, null, -1L));
            if (isDebugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate();
            return n;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            StringBuilder sql = this.toStringBuilder();
            this.debug(Audit.StatementType.UPDATE, sql.toString(), this.log(isDebugEnabled, "executeUpdate", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, count, time), exception);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getTarget().setNull(parameterIndex, sqlType);
        this.addParameter(this.isDebugEnabled(), parameterIndex, NULL);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getTarget().setBoolean(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getTarget().setByte(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getTarget().setShort(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getTarget().setInt(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getTarget().setLong(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.getTarget().setFloat(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getTarget().setDouble(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getTarget().setBigDecimal(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.getTarget().setString(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.getTarget().setBytes(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getTarget().setDate(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getTarget().setTime(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getTarget().setTimestamp(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setUnicodeStream(parameterIndex, x, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.getTarget().clearParameters();
        if (this.parameterMaps != null) {
            this.parameterMaps.get(this.parameterMaps.size() - 1).clear();
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.getTarget().setObject(parameterIndex, x, targetSqlType, scale);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.getTarget().setObject(parameterIndex, x, targetSqlType);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.getTarget().setObject(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        long time = -1L;
        boolean result = false;
        Throwable exception = null;
        boolean isDebugEnabled = this.isDebugEnabled();
        try {
            StringBuilder sql = this.toStringBuilder();
            this.trace(Audit.StatementType.MULTIPLE, sql.toString(), this.log(this.isTraceEnabled(), "execute", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, null, -1L));
            if (isDebugEnabled) {
                time = System.currentTimeMillis();
            }
            boolean bl = result = this.getTarget().execute();
            return bl;
        }
        catch (Throwable t) {
            exception = t;
            throw t;
        }
        finally {
            StringBuilder sql = this.toStringBuilder();
            this.debug(Audit.StatementType.MULTIPLE, sql.toString(), this.log(isDebugEnabled, "execute", true, this.toStringBuilder(), Integer.MIN_VALUE, null, null, result, time), exception);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.logAddBatch(this.isDebugEnabled(), this.sql);
        this.getTarget().addBatch();
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.getTarget().setRef(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.getTarget().setBlob(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.getTarget().setClob(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.getTarget().setArray(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.getTarget().setDate(parameterIndex, x, cal);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.getTarget().setTime(parameterIndex, x, cal);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.getTarget().setTimestamp(parameterIndex, x, cal);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.getTarget().setNull(parameterIndex, sqlType, typeName);
        this.addParameter(this.isDebugEnabled(), parameterIndex, NULL);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.getTarget().setURL(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.getTarget().setRowId(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.getTarget().setNString(parameterIndex, value);
        this.addParameter(this.isDebugEnabled(), parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.getTarget().setNCharacterStream(parameterIndex, value, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.getTarget().setNClob(parameterIndex, value);
        this.addParameter(this.isDebugEnabled(), parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setClob(parameterIndex, reader, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getTarget().setBlob(parameterIndex, inputStream, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setNClob(parameterIndex, reader, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.getTarget().setSQLXML(parameterIndex, xmlObject);
        this.addParameter(this.isDebugEnabled(), parameterIndex, xmlObject);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.getTarget().setCharacterStream(parameterIndex, reader, length);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.getTarget().setAsciiStream(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.getTarget().setBinaryStream(parameterIndex, x);
        this.addParameter(this.isDebugEnabled(), parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setCharacterStream(parameterIndex, reader);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.getTarget().setNCharacterStream(parameterIndex, value);
        this.addParameter(this.isDebugEnabled(), parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setClob(parameterIndex, reader);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.getTarget().setBlob(parameterIndex, inputStream);
        this.addParameter(this.isDebugEnabled(), parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.getTarget().setNClob(parameterIndex, reader);
        this.addParameter(this.isDebugEnabled(), parameterIndex, reader);
    }

    @Override
    public void close() throws SQLException {
        if (this.parameterMaps != null) {
            this.parameterMaps.clear();
            this.parameterMaps = null;
        }
        super.close();
    }

    @Override
    protected boolean toStringBatch(StringBuilder b, int[] count, boolean indent) {
        if (this.parameterMaps == null) {
            return false;
        }
        int size = this.parameterMaps.size();
        if (size > 1) {
            b.append("[\n");
        }
        if (count != null) {
            if (indent) {
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        b.append('\n');
                    }
                    b.append("  ").append((CharSequence)AuditPreparedStatement.toString(this.sql, (Map<Object, Object>)this.parameterMaps.get(i))).append(" -> ").append(count[i]);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        b.append('\n');
                    }
                    b.append((CharSequence)AuditPreparedStatement.toString(this.sql, (Map<Object, Object>)this.parameterMaps.get(i))).append(" -> ").append(count[i]);
                }
            }
        } else if (indent) {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append("  ").append((CharSequence)AuditPreparedStatement.toString(this.sql, (Map<Object, Object>)this.parameterMaps.get(i)));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append((CharSequence)AuditPreparedStatement.toString(this.sql, (Map<Object, Object>)this.parameterMaps.get(i)));
            }
        }
        if (size > 1) {
            b.append("\n]");
        }
        return true;
    }

    private StringBuilder toStringBuilder() {
        if (this.parameterMaps == null) {
            return new StringBuilder(this.sql);
        }
        StringBuilder b = new StringBuilder();
        this.toStringBatch(b, null, false);
        return b;
    }

    @Override
    public String toString() {
        if (this.parameterMaps == null) {
            return this.sql;
        }
        StringBuilder b = new StringBuilder();
        this.toStringBatch(b, null, false);
        return b.toString();
    }
}

