/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import org.libj.lang.Numbers;
import org.libj.lang.Strings;
import org.libj.lang.Systems;
import org.libj.lang.Throwables;
import org.libj.sql.Audit;
import org.libj.sql.AuditCallableStatement;
import org.libj.sql.AuditPreparedStatement;
import org.libj.sql.AuditStatement;
import org.libj.sql.AuditUtil;
import org.libj.sql.DelegateConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditConnection
extends Audit
implements DelegateConnection {
    private static final Logger logger = LoggerFactory.getLogger(AuditConnection.class);
    private static final boolean traceOpenConnections = Systems.hasProperty((String)"org.libj.sql.AuditConnection.trace");
    private static final IdentityHashMap<AuditConnection, Trace> openConnections = traceOpenConnections ? new IdentityHashMap() : null;
    private Connection target;

    public static void traceOpenConnections(Consumer<String> c) {
        if (traceOpenConnections && openConnections.size() > 0) {
            ArrayList<Trace> list = new ArrayList<Trace>(openConnections.values());
            list.sort(null);
            int i$ = list.size();
            for (int i = 0; i < i$; ++i) {
                if (i > 0) {
                    c.accept("\n");
                }
                c.accept(Strings.pad((String)String.valueOf(i), (Strings.Align)Strings.Align.RIGHT, (int)Numbers.precision((int)i$)) + ") " + list.get(i).toString().replace("\n", "\n    "));
            }
        }
    }

    public static Boolean isClosed(Connection connection) {
        try {
            return connection.isClosed();
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(connection.getClass().getName() + ".isClosed(): " + e.getMessage());
            }
            return null;
        }
    }

    public static SQLException close(Connection connection) {
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
            return null;
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(connection.getClass().getName() + ".close(): " + e.getMessage());
            }
            return e;
        }
    }

    public static Connection wrapIfDebugEnabled(Connection target) {
        return traceOpenConnections || logger.isDebugEnabled() ? new AuditConnection(target) : target;
    }

    public AuditConnection(Connection target) {
        this.target = target;
    }

    protected String log(boolean enabled, String method, boolean newLine, String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        if (!enabled) {
            return null;
        }
        StringBuilder b = AuditUtil.log(this, method, this, newLine, new StringBuilder(sql));
        if (autoGeneratedKeys != Integer.MIN_VALUE) {
            b.append(", ").append(autoGeneratedKeys);
        } else if (columnIndexes != null) {
            for (int columnIndex : columnIndexes) {
                b.append(", ").append(columnIndex);
            }
        } else if (columnNames != null) {
            for (String columnName : columnNames) {
                b.append(", ").append(columnName);
            }
        } else {
            if (resultSetType != Integer.MIN_VALUE) {
                b.append(", ").append(resultSetType);
            }
            if (resultSetConcurrency != Integer.MIN_VALUE) {
                b.append(", ").append(resultSetConcurrency);
            }
            if (resultSetHoldability != Integer.MIN_VALUE) {
                b.append(", ").append(resultSetHoldability);
            }
        }
        return b.append("\n)").toString();
    }

    @Override
    public Connection getTarget() {
        return this.target;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    protected Statement wrap(Statement statement) {
        return AuditStatement.wrapIfDebugEnabled(statement);
    }

    protected PreparedStatement wrap(PreparedStatement statement, String sql) {
        return AuditPreparedStatement.wrapIfDebugEnabled(statement, sql);
    }

    protected CallableStatement wrap(CallableStatement statement, String sql) {
        return AuditCallableStatement.wrapIfDebugEnabled(statement, sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        return this.wrap(this.target.createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "executeQuery", true, sql, Integer.MIN_VALUE, null, null, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareStatement(sql), sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        return this.wrap(this.target.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareStatement", true, sql, Integer.MIN_VALUE, null, null, resultSetType, resultSetConcurrency, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareCall", true, sql, Integer.MIN_VALUE, null, null, resultSetType, resultSetConcurrency, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        return this.wrap(this.target.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareStatement", true, sql, Integer.MIN_VALUE, null, null, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        return this.wrap(this.target.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareCall", true, sql, Integer.MIN_VALUE, null, null, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        return this.wrap(this.target.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareStatement", true, sql, autoGeneratedKeys, null, null, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareStatement", true, sql, Integer.MIN_VALUE, columnIndexes, null, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (traceOpenConnections) {
            openConnections.put(this, new Trace());
        }
        this.trace(null, this.log(this.isTraceEnabled(), "prepareStatement", true, sql, Integer.MIN_VALUE, null, columnNames, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE), sql);
        return this.wrap(this.target.prepareStatement(sql, columnNames), sql);
    }

    @Override
    public void close() throws SQLException {
        if (traceOpenConnections) {
            openConnections.remove(this);
        }
        DelegateConnection.super.close();
    }

    public boolean equals(Object obj) {
        return this.getTarget().equals(obj);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return this.getTarget().toString();
    }

    private class Trace
    implements Comparable<Trace> {
        private final String stackTrace = Throwables.toString((Throwable)new Exception());
        private final long timestamp = System.currentTimeMillis();

        private Trace() {
        }

        @Override
        public int compareTo(Trace o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public String toString() {
            return AuditConnection.this + "\nAge: " + (System.currentTimeMillis() - this.timestamp) + "\n" + this.stackTrace;
        }
    }
}

