/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.libj.lang.Strings;
import org.libj.logging.LoggerUtil;
import org.libj.sql.AuditUtil;
import org.libj.sql.DelegateStatement;
import org.libj.sql.ResultSets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class AuditStatement
implements DelegateStatement {
    private static final Logger logger = LoggerFactory.getLogger(AuditStatement.class);
    private final Statement target;
    private ArrayList<String> batch;

    public static SQLException close(Statement statement) {
        try {
            if (!statement.isClosed()) {
                statement.close();
            }
            return null;
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(statement.getClass().getName() + ".close(): " + e.getMessage());
            }
            return e;
        }
    }

    public static Statement wrapIfDebugEnabled(Statement target) {
        return logger.isDebugEnabled() ? new AuditStatement(target) : target;
    }

    public AuditStatement(Statement target) {
        this.target = target;
    }

    @Override
    public Statement getTarget() {
        return this.target;
    }

    static StringBuilder withResult(StringBuilder builder, Object result, long time) {
        builder.append(" -> ").append(result).append("\t\t").append(System.currentTimeMillis() - time).append("ms");
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long time = -1L;
        int size = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeQuery", this.getConnection(), sql).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            ResultSet resultSet = this.getTarget().executeQuery(sql);
            if (LoggerUtil.isLoggable((Logger)logger, (Level)Level.DEBUG)) {
                size = ResultSets.getSize(resultSet);
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "executeQuery", this.getConnection(), sql), size, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        long time = -1L;
        int count = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate(sql);
            return n;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql), count, time).toString());
            }
        }
    }

    @Override
    public void close() throws SQLException {
        block4: {
            try {
                Statement target = this.getTarget();
                if (!target.isClosed()) {
                    target.close();
                }
                if (this.batch != null) {
                    this.batch.clear();
                    this.batch = null;
                }
            }
            catch (SQLException e) {
                if ("Connection is closed.".equals(e.getMessage())) break block4;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        long time = -1L;
        Boolean result = null;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "execute", this.getConnection(), sql).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            result = this.getTarget().execute(sql);
            boolean bl = result;
            return bl;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "execute", this.getConnection(), sql), result, time).toString());
            }
        }
    }

    protected final void addBatch0(String sql) {
        if (this.batch == null) {
            this.batch = new ArrayList();
        }
        this.batch.add(sql);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            this.addBatch0(sql);
        }
        this.getTarget().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getTarget().clearBatch();
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    private String logExecuteBatch(int[] count, Long time) throws SQLException {
        StringBuilder builder = AuditUtil.log(this, "executeBatch", this.getConnection(), null);
        builder.setLength(builder.length() - 3);
        builder.append('[');
        if (this.batch != null) {
            if (count != null) {
                int i$ = this.batch.size();
                for (int i = 0; i < i$; ++i) {
                    builder.append("\n ").append((CharSequence)Strings.indent((String)this.batch.get(i), (int)2)).append(" -> ").append(count[i]);
                }
            } else {
                int i$ = this.batch.size();
                for (int i = 0; i < i$; ++i) {
                    builder.append("\n ").append((CharSequence)Strings.indent((String)this.batch.get(i), (int)2)).append(" -> -1");
                }
            }
        }
        builder.append("\n])");
        if (time != null) {
            builder.append(' ').append(System.currentTimeMillis() - time).append("ms");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        long time = -1L;
        int[] count = null;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(this.logExecuteBatch(count, null));
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int[] nArray = count = this.getTarget().executeBatch();
            return nArray;
        }
        finally {
            if (debugEnabled) {
                logger.debug(this.logExecuteBatch(count, time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long time = -1L;
        int count = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql).append("\n,  ").append(autoGeneratedKeys), count, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long time = -1L;
        int count = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql).append("\n, [").append(Arrays.toString(columnIndexes)).append(']'), count, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long time = -1L;
        int count = -1;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql + "\n,  " + Arrays.toString(columnNames)).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            int n = count = this.getTarget().executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "executeUpdate", this.getConnection(), sql + "\n,  " + Arrays.toString(columnNames)), count, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        long time = -1L;
        Boolean result = null;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + autoGeneratedKeys).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            result = this.getTarget().execute(sql, autoGeneratedKeys);
            boolean bl = result;
            return bl;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + autoGeneratedKeys), result, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        long time = -1L;
        Boolean result = null;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + Arrays.toString(columnIndexes)).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            result = this.getTarget().execute(sql, columnIndexes);
            boolean bl = result;
            return bl;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + Arrays.toString(columnIndexes)), result, time).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        long time = -1L;
        Boolean result = null;
        boolean debugEnabled = logger.isDebugEnabled();
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + Arrays.toString(columnNames)).toString());
            }
            if (debugEnabled) {
                time = System.currentTimeMillis();
            }
            result = this.getTarget().execute(sql, columnNames);
            boolean bl = result;
            return bl;
        }
        finally {
            if (debugEnabled) {
                logger.debug(AuditStatement.withResult(AuditUtil.log(this, "execute", this.getConnection(), sql + "\n,  " + Arrays.toString(columnNames)), result, time).toString());
            }
        }
    }

    public boolean equals(Object obj) {
        return this.getTarget().equals(obj);
    }

    public int hashCode() {
        return this.getTarget().hashCode();
    }

    public String toString() {
        return this.getTarget().toString();
    }
}

