/*
 * Decompiled with CFR 0.152.
 */
package org.libj.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.function.Consumer;
import org.libj.lang.Numbers;
import org.libj.lang.Strings;
import org.libj.lang.Systems;
import org.libj.lang.Throwables;
import org.libj.sql.AuditCallableStatement;
import org.libj.sql.AuditPreparedStatement;
import org.libj.sql.AuditStatement;
import org.libj.sql.AuditUtil;
import org.libj.sql.DelegateConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditConnection
extends DelegateConnection {
    private static final Logger logger = LoggerFactory.getLogger(AuditConnection.class);
    private static final boolean trace = Systems.hasProperty((String)"org.libj.sql.AuditConnection.trace");
    private static final IdentityHashMap<AuditConnection, Trace> openConnections = trace ? new IdentityHashMap() : null;

    public static void traceOpenConnections(Consumer<String> c) {
        if (trace && openConnections.size() > 0) {
            ArrayList<Trace> list = new ArrayList<Trace>(openConnections.values());
            list.sort(null);
            int i$ = list.size();
            for (int i = 0; i < i$; ++i) {
                if (i > 0) {
                    c.accept("\n");
                }
                c.accept(Strings.pad((String)String.valueOf(i), (Strings.Align)Strings.Align.RIGHT, (int)Numbers.precision((int)i$)) + ") " + list.get(i).toString().replace("\n", "\n    "));
            }
        }
    }

    public static Boolean isClosed(Connection connection) {
        try {
            return connection.isClosed();
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(connection.getClass().getName() + ".isClosed(): " + e.getMessage());
            }
            return null;
        }
    }

    public static SQLException close(Connection connection) {
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
            return null;
        }
        catch (SQLException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(connection.getClass().getName() + ".close(): " + e.getMessage());
            }
            return e;
        }
    }

    public static Connection wrapIfDebugEnabled(Connection target) {
        return trace || logger.isDebugEnabled() ? new AuditConnection(target) : target;
    }

    public AuditConnection(Connection target) {
        super(target);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        return AuditStatement.wrapIfDebugEnabled(this.target.createStatement());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql), sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        return AuditStatement.wrapIfDebugEnabled(this.target.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareCall", this, sql).toString());
        }
        return AuditCallableStatement.wrapIfDebugEnabled(this.target.prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        return AuditStatement.wrapIfDebugEnabled(this.target.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareCall", this, sql).toString());
        }
        return AuditCallableStatement.wrapIfDebugEnabled(this.target.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (trace) {
            openConnections.put(this, new Trace());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(AuditUtil.log(this, "prepareStatement", this, sql).toString());
        }
        return AuditPreparedStatement.wrapIfDebugEnabled(this.target.prepareStatement(sql, columnNames), sql);
    }

    @Override
    public void close() throws SQLException {
        if (trace) {
            openConnections.remove(this);
        }
        super.close();
    }

    private class Trace
    implements Comparable<Trace> {
        private final String stackTrace = Throwables.toString((Throwable)new Exception());
        private final long timestamp = System.currentTimeMillis();

        private Trace() {
        }

        @Override
        public int compareTo(Trace o) {
            return Long.compare(this.timestamp, o.timestamp);
        }

        public String toString() {
            return AuditConnection.this + "\nAge: " + (System.currentTimeMillis() - this.timestamp) + "\n" + this.stackTrace;
        }
    }
}

