/*
 * Decompiled with CFR 0.152.
 */
package org.libj.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public final class LoggerUtil {
    static final Level[] logbackLevel = new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};

    public static void setLevel(Logger logger, org.slf4j.event.Level level) {
        ((ch.qos.logback.classic.Logger)logger).setLevel(logbackLevel[level.ordinal()]);
    }

    public static boolean loadConfigExcludeLocation(Class<?> cls) {
        return LoggerUtil.loadConfigViaLocation(cls, true);
    }

    public static boolean loadConfigIncludeLocation(Class<?> cls) {
        return LoggerUtil.loadConfigViaLocation(cls, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadConfigViaLocation(Class<?> cls, boolean exclude) {
        String classResource = cls.getName().replace('.', '/').concat(".class");
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL classResourceUrl = classLoader.getResource(classResource);
        if (classResourceUrl == null) return false;
        try {
            URL url;
            String classResourcePath = classResourceUrl.toString();
            Enumeration<URL> e = classLoader.getResources("logback.xml");
            do {
                if (!e.hasMoreElements()) return false;
            } while ((url = e.nextElement()).toString().regionMatches(0, classResourcePath, 0, classResourcePath.length() - classResource.length()) == exclude);
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            try (InputStream in = url.openStream();){
                configurator.doConfigure(in);
                boolean bl = true;
                return bl;
            }
        }
        catch (JoranException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isLoggable(Logger logger, org.slf4j.event.Level level) {
        return logger != null && level != null && (level == org.slf4j.event.Level.INFO && logger.isInfoEnabled() || level == org.slf4j.event.Level.DEBUG && logger.isDebugEnabled() || level == org.slf4j.event.Level.TRACE && logger.isTraceEnabled() || level == org.slf4j.event.Level.WARN && logger.isWarnEnabled() || level == org.slf4j.event.Level.ERROR && logger.isErrorEnabled());
    }

    public static boolean isLoggable(Logger logger, org.slf4j.event.Level level, Marker marker) {
        return logger != null && level != null && (level == org.slf4j.event.Level.INFO && logger.isInfoEnabled(marker) || level == org.slf4j.event.Level.DEBUG && logger.isDebugEnabled(marker) || level == org.slf4j.event.Level.TRACE && logger.isTraceEnabled(marker) || level == org.slf4j.event.Level.WARN && logger.isWarnEnabled(marker) || level == org.slf4j.event.Level.ERROR && logger.isErrorEnabled(marker));
    }

    public static void log(Logger logger, org.slf4j.event.Level level, String msg) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(msg);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(msg);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(msg);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(msg);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(msg);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, String format, Object arg) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(format, arg);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(format, arg);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(format, arg);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(format, arg);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(format, arg);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, String format, Object arg1, Object arg2) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(format, arg1, arg2);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, String format, Object ... arguments) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(format, arguments);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(format, arguments);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(format, arguments);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(format, arguments);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(format, arguments);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, String msg, Throwable t) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(msg, t);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(msg, t);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(msg, t);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(msg, t);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(msg, t);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, Marker marker, String msg) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(marker, msg);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(marker, msg);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(marker, msg);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(marker, msg);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(marker, msg);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, Marker marker, String format, Object arg) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(marker, format, arg);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(marker, format, arg);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(marker, format, arg);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(marker, format, arg);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(marker, format, arg);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, Marker marker, String format, Object arg1, Object arg2) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(marker, format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(marker, format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(marker, format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(marker, format, arg1, arg2);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(marker, format, arg1, arg2);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, Marker marker, String format, Object ... arguments) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(marker, format, arguments);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(marker, format, arguments);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(marker, format, arguments);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(marker, format, arguments);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(marker, format, arguments);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    public static void log(Logger logger, org.slf4j.event.Level level, Marker marker, String msg, Throwable t) {
        if (level == org.slf4j.event.Level.INFO) {
            logger.info(marker, msg, t);
        } else if (level == org.slf4j.event.Level.DEBUG) {
            logger.debug(marker, msg, t);
        } else if (level == org.slf4j.event.Level.TRACE) {
            logger.trace(marker, msg, t);
        } else if (level == org.slf4j.event.Level.WARN) {
            logger.warn(marker, msg, t);
        } else if (level == org.slf4j.event.Level.ERROR) {
            logger.error(marker, msg, t);
        } else {
            throw new UnsupportedOperationException("Unsupported level: " + level);
        }
    }

    private static int convert(StringBuilder builder, CharSequence str, int a, Object[] args) {
        int i = 0;
        int i$ = str.length();
        while (i < i$) {
            char ch;
            if ((ch = str.charAt(i++)) == '%') {
                if (i < str.length() && str.charAt(i) == '?') {
                    Object arg;
                    ++i;
                    if ((arg = args[a++]) != null) {
                        Class<?> cls = arg.getClass();
                        builder.append(cls.isAnonymousClass() ? cls.getName() : cls.getSimpleName()).append("@%h");
                        continue;
                    }
                    builder.append("%s");
                    continue;
                }
                ++a;
            }
            builder.append(ch);
        }
        return a;
    }

    public static void logm(Logger logger, org.slf4j.event.Level level, String method, String format, Object ... args) {
        if (!LoggerUtil.isLoggable(logger, level)) {
            return;
        }
        int i$ = args.length;
        for (int i = 0; i < i$; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            if (arg.getClass().isArray()) {
                args[i] = Arrays.toString((Object[])arg);
                continue;
            }
            if (!(arg instanceof Class)) continue;
            args[i] = ((Class)arg).getSimpleName();
        }
        StringBuilder builder = new StringBuilder();
        int a = LoggerUtil.convert(builder, method, 0, args);
        builder.append('(');
        if (format != null) {
            LoggerUtil.convert(builder, format, a, args);
            builder.append(')');
        } else if (args.length > 0 && a < args.length) {
            int i$2 = args.length;
            for (int i = a; i < i$2; ++i) {
                builder.append("%s,");
            }
            builder.setCharAt(builder.length() - 1, ')');
        } else {
            builder.append(')');
        }
        String msg = args.length > 0 ? String.format(builder.toString(), args) : builder.toString();
        LoggerUtil.log(logger, level, (Marker)null, msg, null);
    }

    public static void logm(Logger logger, org.slf4j.event.Level level, String method, Object ... args) {
        LoggerUtil.logm(logger, level, method, null, args);
    }

    private LoggerUtil() {
    }
}

