/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import org.libj.lang.Booleans;
import org.libj.lang.Numbers;

public final class Systems {
    public static boolean hasProperty(String key) {
        String prop = System.getProperty(key);
        return prop != null && !prop.equals("false");
    }

    public static int getProperty(String primaryKey, String fallbackKey, int defaultValue) throws SecurityException {
        String value = System.getProperty(primaryKey);
        if (value != null) {
            return Numbers.parseInt((CharSequence)value, defaultValue);
        }
        return Systems.getProperty(fallbackKey, defaultValue);
    }

    public static int getProperty(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return Numbers.parseInt((CharSequence)value, defaultValue);
        }
        return defaultValue;
    }

    public static boolean getProperty(String primaryKey, String fallbackKey, boolean defaultValue) {
        String value = System.getProperty(primaryKey);
        if (value != null) {
            return Booleans.parseBoolean(value, defaultValue);
        }
        return Systems.getProperty(fallbackKey, defaultValue);
    }

    public static boolean getProperty(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return Booleans.parseBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    public static String getProperty(String primaryKey, String fallbackKey) {
        String value = System.getProperty(primaryKey);
        return value != null ? value : System.getProperty(fallbackKey);
    }

    private Systems() {
    }
}

