/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.Closeable;
import java.util.Objects;
import java.util.function.Consumer;

public final class Runtimes {
    public static void closeOnExit(AutoCloseable closeable) {
        Runtimes.closeOnExit(closeable, null);
    }

    public static void closeOnExit(final AutoCloseable closeable, final Consumer<Exception> onException) {
        Objects.requireNonNull(closeable);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (onException != null) {
                        onException.accept(e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void closeOnExit(Closeable closeable) {
        Runtimes.closeOnExit(closeable, null);
    }

    public static void closeOnExit(final Closeable closeable, final Consumer<Exception> onException) {
        Objects.requireNonNull(closeable);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    if (onException != null) {
                        onException.accept(e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Runtimes() {
    }
}

