/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public final class ObjectUtil {
    private static final HashMap<Class<?>, Method> classToCloneMethod = new HashMap();

    public static <T> T identity(T obj) {
        return obj;
    }

    public static String identityString(Object obj) {
        return obj == null ? "null" : obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static String simpleIdentityString(Object obj) {
        return obj == null ? "null" : obj.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static <T extends Cloneable> T clone(T obj) {
        Class<?> cls = obj.getClass();
        Method cloneMethod = classToCloneMethod.get(cls);
        if (cloneMethod == null) {
            try {
                cloneMethod = obj.getClass().getDeclaredMethod("clone", new Class[0]);
                classToCloneMethod.put(cls, cloneMethod);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            cloneMethod.setAccessible(true);
            Cloneable clone = (Cloneable)cloneMethod.invoke(obj, new Object[0]);
            cloneMethod.setAccessible(false);
            return (T)clone;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        Object[] a1;
        int length;
        Object[] a2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (c1 == Optional.class) {
            return c2 == Optional.class && ObjectUtil.equals(((Optional)o1).orElse(null), ((Optional)o2).orElse(null));
        }
        if (o1 instanceof Iterable) {
            if (!(o2 instanceof Iterable)) {
                return false;
            }
            Iterator i1 = ((Iterable)o1).iterator();
            Iterator i2 = ((Iterable)o2).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (ObjectUtil.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return !i1.hasNext() && !i2.hasNext();
        }
        if (!c1.isArray()) {
            return !c2.isArray() && Objects.equals(o1, o2);
        }
        Class<?> t1 = c1.getComponentType();
        Class<?> t2 = c2.getComponentType();
        if (t1.isPrimitive() || t2.isPrimitive()) {
            if (t1 != t2) {
                return false;
            }
            if (t1 == Boolean.TYPE) {
                return Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (t1 == Byte.TYPE) {
                return Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (t1 == Character.TYPE) {
                return Arrays.equals((char[])o1, (char[])o2);
            }
            if (t1 == Short.TYPE) {
                return Arrays.equals((short[])o1, (short[])o2);
            }
            if (t1 == Integer.TYPE) {
                return Arrays.equals((int[])o1, (int[])o2);
            }
            if (t1 == Long.TYPE) {
                return Arrays.equals((long[])o1, (long[])o2);
            }
            if (t1 == Float.TYPE) {
                return Arrays.equals((float[])o1, (float[])o2);
            }
            if (t1 == Double.TYPE) {
                return Arrays.equals((double[])o1, (double[])o2);
            }
        }
        if ((a2 = (Object[])o2).length != (length = (a1 = (Object[])o1).length)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (ObjectUtil.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        Class<?> cls = obj.getClass();
        if (cls == Optional.class) {
            return ObjectUtil.hashCode(((Optional)obj).orElse(null));
        }
        if (Iterable.class.isAssignableFrom(cls)) {
            Iterator i = ((Iterable)obj).iterator();
            int result = 1;
            while (i.hasNext()) {
                Object element = i.next();
                result = 31 * result + (element == null ? 0 : ObjectUtil.hashCode(element));
            }
            return result;
        }
        if (!cls.isArray()) {
            return obj.hashCode();
        }
        Class<?> type = cls.getComponentType();
        if (type == Boolean.TYPE) {
            return Arrays.hashCode((boolean[])obj);
        }
        if (type == Byte.TYPE) {
            return Arrays.hashCode((byte[])obj);
        }
        if (type == Character.TYPE) {
            return Arrays.hashCode((char[])obj);
        }
        if (type == Short.TYPE) {
            return Arrays.hashCode((short[])obj);
        }
        if (type == Integer.TYPE) {
            return Arrays.hashCode((int[])obj);
        }
        if (type == Long.TYPE) {
            return Arrays.hashCode((long[])obj);
        }
        if (type == Float.TYPE) {
            return Arrays.hashCode((float[])obj);
        }
        if (type == Double.TYPE) {
            return Arrays.hashCode((double[])obj);
        }
        int result = 1;
        for (Object element : (Object[])obj) {
            result = 31 * result + (element == null ? 0 : ObjectUtil.hashCode(element));
        }
        return result;
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> cls = obj.getClass();
        if (!cls.isArray()) {
            return obj.toString();
        }
        Class<?> type = cls.getComponentType();
        if (type == Boolean.TYPE) {
            return Arrays.toString((boolean[])obj);
        }
        if (type == Byte.TYPE) {
            return Arrays.toString((byte[])obj);
        }
        if (type == Character.TYPE) {
            return Arrays.toString((char[])obj);
        }
        if (type == Short.TYPE) {
            return Arrays.toString((short[])obj);
        }
        if (type == Integer.TYPE) {
            return Arrays.toString((int[])obj);
        }
        if (type == Long.TYPE) {
            return Arrays.toString((long[])obj);
        }
        if (type == Float.TYPE) {
            return Arrays.toString((float[])obj);
        }
        if (type == Double.TYPE) {
            return Arrays.toString((double[])obj);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Object[] array = (Object[])obj;
        int i$ = array.length;
        for (int i = 0; i < i$; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(ObjectUtil.toString(array[i]));
        }
        builder.append(']');
        return builder.toString();
    }

    private ObjectUtil() {
    }
}

