/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.reflect.Array;
import java.util.List;

public final class Enums {
    private static <T extends Enum<T>> T[] recurseValueOf(Class<T> type, String[] names, int length, int index, int depth) {
        Object value;
        if (index == length) {
            return (Enum[])Array.newInstance(type, depth);
        }
        try {
            value = Enum.valueOf(type, names[index]);
        }
        catch (IllegalArgumentException e) {
            value = null;
        }
        if (value == null) {
            return Enums.recurseValueOf(type, (String[])names, (int)length, (int)(index + 1), (int)depth);
        }
        Enum[] enums = Enums.recurseValueOf(type, (String[])names, (int)length, (int)(index + 1), (int)(depth + 1));
        enums[depth] = value;
        return enums;
    }

    public static <T extends Enum<T>> T[] valueOf(Class<T> type, String ... names) {
        return Enums.recurseValueOf(type, (String[])names, (int)names.length, (int)0, (int)0);
    }

    public static <T extends Enum<T>> T[] valueOf(Class<T> type, List<String> names) {
        return Enums.valueOf(type, (String[])names.toArray(new String[names.size()]));
    }

    private Enums() {
    }

    public static final class Mask {
        @SafeVarargs
        public static <E extends Enum<?>> byte toggle(byte mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (byte)(mask ^ 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> short toggle(short mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (short)(mask ^ 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> int toggle(int mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask ^= 1 << ((Enum)enums[i]).ordinal();
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> long toggle(long mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask ^= (long)(1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> byte set(byte mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (byte)(mask | 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> short set(short mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (short)(mask | 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> int set(int mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask |= 1 << ((Enum)enums[i]).ordinal();
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> long set(long mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask |= (long)(1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> byte unset(byte mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (byte)(mask & 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> short unset(short mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask = (short)(mask & 1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> int unset(int mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask &= 1 << ((Enum)enums[i]).ordinal();
            }
            return mask;
        }

        @SafeVarargs
        public static <E extends Enum<?>> long unset(long mask, E ... enums) {
            int i$ = enums.length;
            for (int i = 0; i < i$; ++i) {
                mask &= (long)(1 << ((Enum)enums[i]).ordinal());
            }
            return mask;
        }

        public static boolean check(byte mask, int ordinal) {
            return (mask & 1 << ordinal) != 0;
        }

        public static boolean check(short mask, int ordinal) {
            return (mask & 1 << ordinal) != 0;
        }

        public static boolean check(int mask, int ordinal) {
            return (mask & 1 << ordinal) != 0;
        }

        public static boolean check(long mask, int ordinal) {
            return (mask & (long)(1 << ordinal)) != 0L;
        }

        public static boolean check(byte mask, Enum<?> enm) {
            return Mask.check(mask, enm.ordinal());
        }

        public static boolean check(short mask, Enum<?> enm) {
            return Mask.check(mask, enm.ordinal());
        }

        public static boolean check(int mask, Enum<?> enm) {
            return Mask.check(mask, enm.ordinal());
        }

        public static boolean check(long mask, Enum<?> enm) {
            return Mask.check(mask, enm.ordinal());
        }

        @SafeVarargs
        public static <E extends Enum<?>> E[] toArray(byte mask, E ... values) {
            return Mask.toArray(values, (int)mask, (int)8, (int)0, (int)0);
        }

        @SafeVarargs
        public static <E extends Enum<?>> E[] toArray(short mask, E ... values) {
            return Mask.toArray(values, (int)mask, (int)16, (int)0, (int)0);
        }

        @SafeVarargs
        public static <E extends Enum<?>> E[] toArray(int mask, E ... values) {
            return Mask.toArray(values, (int)mask, (int)32, (int)0, (int)0);
        }

        @SafeVarargs
        public static <E extends Enum<?>> E[] toArray(long mask, E ... values) {
            return Mask.toArray(values, (long)mask, (int)0, (int)0);
        }

        private static <E extends Enum<?>> E[] toArray(E[] values, int mask, int size, int index, int depth) {
            for (int i = index; i < size; ++i) {
                if ((mask & 1 << i) == 0) continue;
                E enm = values[i];
                Enum[] array = Mask.toArray(values, (int)mask, (int)size, (int)(index + 1), (int)(depth + 1));
                array[depth] = enm;
                return array;
            }
            return (Enum[])Array.newInstance(values.getClass().getComponentType(), depth);
        }

        private static <E extends Enum<?>> E[] toArray(E[] values, long mask, int index, int depth) {
            for (int i = index; i < 64; ++i) {
                if ((mask & (long)(1 << i)) == 0L) continue;
                E enm = values[i];
                Enum[] array = Mask.toArray(values, (long)mask, (int)(index + 1), (int)(depth + 1));
                array[depth] = enm;
                return array;
            }
            return (Enum[])Array.newInstance(values.getClass().getComponentType(), depth);
        }

        private Mask() {
        }
    }
}

