/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class BigIntegers {
    private static final ConcurrentHashMap<String, BigInteger> instances = new ConcurrentHashMap();
    public static final BigInteger ZERO = BigIntegers.init("0", BigInteger.ZERO);
    public static final BigInteger ONE = BigIntegers.init("1", BigInteger.ONE);
    public static final BigInteger TWO = BigIntegers.init("2", BigInteger.valueOf(2L));
    public static final BigInteger TEN = BigIntegers.init("10", BigInteger.TEN);

    private static BigInteger init(String str, BigInteger val) {
        instances.put(str, val);
        return val;
    }

    public static BigInteger intern(String val) {
        BigInteger intern = instances.get(Objects.requireNonNull(val));
        return intern != null ? intern : BigIntegers.init(val, new BigInteger(val));
    }

    public static BigInteger intern(BigInteger n) {
        BigInteger instance = instances.putIfAbsent(n.toString(), n);
        return instance != null ? instance : n;
    }

    public static BigInteger valueOf(int signum, int mag) {
        long signed = Integer.toUnsignedLong(mag);
        return BigInteger.valueOf(signum < 0 ? -signed : signed);
    }

    public static BigInteger valueOf(int signum, long mag) {
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (signum == 0) {
            if (mag != 0L) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            return BigInteger.ZERO;
        }
        if (mag >= 0L) {
            return BigInteger.valueOf(signum == -1 ? -mag : mag);
        }
        long upper = (long)signum * Integer.toUnsignedLong((int)(mag >>> 32));
        long lower = (long)signum * Integer.toUnsignedLong((int)mag);
        return BigInteger.valueOf(upper).shiftLeft(32).add(BigInteger.valueOf(lower));
    }

    public static BigInteger valueOf(int signum, byte[] mag) {
        return new BigInteger(signum, mag);
    }

    private BigIntegers() {
    }
}

