/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.Arrays;
import org.libj.lang.DataEncoding;

public class Base32
extends DataEncoding<byte[], String> {
    private static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] lookup = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    public static String encode(byte[] bytes) {
        return Base32.encode(bytes, 0, bytes.length);
    }

    public static String encode(byte[] bytes, int offset, int len) {
        StringBuilder base32 = new StringBuilder((bytes.length + 7) * 8 / 5);
        int i = offset;
        int index = 0;
        while (i < len + offset) {
            int digit;
            int by0;
            int n = by0 = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int by1 = i + 1 < bytes.length ? (bytes[i + 1] < 0 ? bytes[i + 1] + 256 : bytes[i + 1]) : 0;
                digit = by0 & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= by1 >> 8 - index;
                ++i;
            } else {
                digit = by0 >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(alphabet.charAt(digit));
        }
        return base32.toString();
    }

    public static byte[] decode(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        Base32.decode(base32, bytes, 0);
        return bytes;
    }

    public static void decode(String base32, byte[] bytes, int offset) {
        int i$ = base32.length();
        int index = 0;
        for (int i = 0; i < i$; ++i) {
            int digit;
            int ch = base32.charAt(i) - 48;
            if (ch < 0 || lookup.length < ch || (digit = lookup[ch]) == 255) continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
    }

    public Base32(byte[] bytes) {
        super(bytes, null);
    }

    public Base32(String base32) {
        super(null, base32);
    }

    @Override
    public byte[] getData() {
        byte[] byArray;
        if (this.data == null) {
            byte[] byArray2 = Base32.decode((String)((Object)this.encoded));
            this.data = byArray2;
            byArray = byArray2;
        } else {
            byArray = (byte[])this.data;
        }
        return byArray;
    }

    @Override
    public String getEncoded() {
        String string;
        if (this.encoded == null) {
            this.encoded = Base32.encode((byte[])this.data);
            string = this.encoded;
        } else {
            string = (String)((Object)this.encoded);
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Base32)) {
            return false;
        }
        Base32 that = (Base32)obj;
        return this.encoded != null && that.encoded != null ? ((String)((Object)this.encoded)).equalsIgnoreCase((String)((Object)that.encoded)) : Arrays.equals(this.getData(), that.getData());
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.getData());
    }

    public String toString() {
        return this.getEncoded();
    }
}

