/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.libheiffx.HEIFImageLoaderFactory;
import org.libheiffx.LibheifImage;

public class TestApp
extends Application {
    public void start(Stage stage) throws FileNotFoundException, IOException {
        HEIFImageLoaderFactory.install();
        Application.Parameters parameters = this.getParameters();
        String file = (String)parameters.getRaw().get(0);
        String file2 = (String)parameters.getRaw().get(1);
        String file3 = (String)parameters.getRaw().get(2);
        VBox stack = new VBox();
        stack.setPadding(new Insets(10.0));
        stack.setSpacing(5.0);
        stack.setAlignment(Pos.TOP_CENTER);
        this.loadImagesByStream(stack, file, file2, file3);
        Scene scene = new Scene((Parent)stack, 640.0, 480.0);
        stage.setScene(scene);
        stage.show();
    }

    private void loadImagesByStream(VBox stack, String file, String file2, String file3) throws MalformedURLException {
        File initialFile = new File(file);
        File initialFile2 = new File(file2);
        File initialFile3 = new File(file3);
        Button btn = new Button("Refresh");
        stack.getChildren().add((Object)btn);
        stack.getChildren().add((Object)new ProgressBar());
        this.loadImages(stack, initialFile, initialFile2, initialFile3);
        btn.setOnAction(t -> {
            stack.getChildren().clear();
            stack.getChildren().add((Object)btn);
            ProgressBar prg = new ProgressBar();
            stack.getChildren().add((Object)prg);
            Platform.runLater(() -> {
                try {
                    this.loadImages(stack, initialFile, initialFile2, initialFile3);
                    stack.getChildren().remove((Object)prg);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(TestApp.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        });
    }

    private void loadImages(VBox stack, File initialFile, File initialFile2, File initialFile3) throws MalformedURLException {
        boolean backgroundLoading = true;
        int size = 200;
        ImageView view = new ImageView();
        ImageView view2 = new ImageView();
        ImageView view3 = new ImageView();
        ProgressIndicator ind = new ProgressIndicator();
        ProgressIndicator ind2 = new ProgressIndicator();
        ProgressIndicator ind3 = new ProgressIndicator();
        stack.getChildren().add((Object)ind);
        stack.getChildren().add((Object)ind2);
        stack.getChildren().add((Object)ind3);
        Image img = new Image(initialFile.toURI().toURL().toString(), (double)size, (double)size, true, true, backgroundLoading);
        img.progressProperty().addListener((ov, t, t1) -> {
            if (t1.doubleValue() == 1.0) {
                stack.getChildren().remove((Object)ind);
                HBox hb = new HBox();
                stack.getChildren().add((Object)hb);
                hb.getChildren().add((Object)view);
                Platform.runLater(() -> {
                    try {
                        HashMap<String, String> metaData = new LibheifImage(initialFile.getAbsolutePath()).getMetaData();
                        ScrollPane sc = new ScrollPane();
                        TextArea vb = new TextArea();
                        metaData.entrySet().forEach(entry -> vb.appendText((String)entry.getKey() + " " + (String)entry.getValue() + "\n"));
                        sc.setContent((Node)vb);
                        hb.getChildren().add((Object)sc);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TestApp.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                if (img.getException() != null) {
                    System.out.println("Exception for: " + img.getUrl());
                    img.getException().printStackTrace();
                }
            }
        });
        ind.progressProperty().bind((ObservableValue)img.progressProperty());
        Image img2 = new Image(initialFile2.toURI().toURL().toString(), (double)size, (double)size, true, true, backgroundLoading);
        img2.progressProperty().addListener((ov, t, t1) -> {
            if (t1.doubleValue() == 1.0) {
                stack.getChildren().remove((Object)ind2);
                HBox hb = new HBox();
                stack.getChildren().add((Object)hb);
                hb.getChildren().add((Object)view2);
                Platform.runLater(() -> {
                    try {
                        HashMap<String, String> metaData = new LibheifImage(initialFile2.getAbsolutePath()).getMetaData();
                        ScrollPane sc = new ScrollPane();
                        TextArea vb = new TextArea();
                        metaData.entrySet().forEach(entry -> vb.appendText((String)entry.getKey() + " " + (String)entry.getValue() + "\n"));
                        sc.setContent((Node)vb);
                        hb.getChildren().add((Object)sc);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TestApp.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                if (img2.getException() != null) {
                    System.out.println("Exception for: " + img2.getUrl());
                    img2.getException().printStackTrace();
                }
            }
        });
        ind2.progressProperty().bind((ObservableValue)img2.progressProperty());
        Image img3 = new Image(initialFile3.toURI().toURL().toString(), (double)size, (double)size, true, true, backgroundLoading);
        img3.progressProperty().addListener((ov, t, t1) -> {
            if (t1.doubleValue() == 1.0) {
                stack.getChildren().remove((Object)ind3);
                HBox hb = new HBox();
                stack.getChildren().add((Object)hb);
                hb.getChildren().add((Object)view3);
                Platform.runLater(() -> {
                    try {
                        HashMap<String, String> metaData = new LibheifImage(initialFile3.getAbsolutePath()).getMetaData();
                        ScrollPane sc = new ScrollPane();
                        TextArea vb = new TextArea();
                        metaData.entrySet().forEach(entry -> vb.appendText((String)entry.getKey() + " " + (String)entry.getValue() + "\n"));
                        sc.setContent((Node)vb);
                        hb.getChildren().add((Object)sc);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TestApp.class.getName()).log(Level.SEVERE, null, ex);
                    }
                });
                if (img3.getException() != null) {
                    System.out.println("Exception for: " + img3.getUrl());
                    img3.getException().printStackTrace();
                }
            }
        });
        ind3.progressProperty().bind((ObservableValue)img3.progressProperty());
        view.setImage(img);
        view.setFitHeight((double)size);
        view.setFitWidth((double)size);
        view.setPreserveRatio(true);
        view2.setImage(img2);
        view2.setFitHeight((double)size);
        view2.setFitWidth((double)size);
        view2.setPreserveRatio(true);
        view3.setImage(img3);
        view3.setFitHeight((double)size);
        view3.setFitWidth((double)size);
        view3.setPreserveRatio(true);
    }

    private void loadImagesByFile(VBox stack, String file) throws IOException {
        File initialFile = new File(file);
        LibheifImage libheif = new LibheifImage(initialFile.getAbsolutePath());
        for (int i = 0; i < 5; ++i) {
            System.out.println("i " + i);
            int[] raw = libheif.readPixelData();
            WritableImage img = new WritableImage(libheif.getImageWidth(), libheif.getImageHeight());
            PixelWriter pw = img.getPixelWriter();
            pw.setPixels(0, 0, libheif.getImageWidth(), libheif.getImageHeight(), (PixelFormat)PixelFormat.getIntArgbInstance(), raw, 0, libheif.getImageWidth());
            ImageView view = new ImageView();
            view.setFitHeight(400.0);
            view.setFitWidth(400.0);
            view.setPreserveRatio(true);
            stack.getChildren().add((Object)view);
            view.setImage((Image)img);
            raw = null;
        }
        System.out.println("Finished!");
    }

    public static void main(String[] args) {
        args = new String[3];
        args[2] = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "ressources" + File.separator + "image0.heic";
        args[1] = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "ressources" + File.separator + "image1.heic";
        args[0] = System.getProperty("user.dir") + File.separator + "src" + File.separator + "main" + File.separator + "ressources" + File.separator + "image2.heic";
        Logger logger = Logger.getLogger("");
        ConsoleHandler handler = new ConsoleHandler();
        logger.addHandler(handler);
        logger.setLevel(Level.ALL);
        handler.setFormatter(new SimpleFormatter());
        TestApp.launch((String[])args);
    }
}

