/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public abstract class MappedFileBuffer
extends DataBuffer {
    private final Buffer buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedFileBuffer(int type, int size, int numBanks) throws IOException {
        super(type, size, numBanks);
        int componentSize = DataBuffer.getDataTypeSize(type) / 8;
        File tempFile = File.createTempFile(String.format("%s-", this.getClass().getSimpleName().toLowerCase()), ".tmp");
        try {
            RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
            long length = (long)size * (long)componentSize * (long)numBanks;
            raf.setLength(length);
            FileChannel channel = raf.getChannel();
            MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            switch (type) {
                case 0: {
                    this.buffer = byteBuffer;
                    break;
                }
                case 1: {
                    this.buffer = byteBuffer.asShortBuffer();
                    break;
                }
                case 3: {
                    this.buffer = byteBuffer.asIntBuffer();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + type);
                }
            }
            channel.close();
        }
        finally {
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }

    public String toString() {
        return String.format("MappedFileBuffer: %s", this.buffer);
    }

    public static DataBuffer create(int type, int size, int numBanks) throws IOException {
        switch (type) {
            case 0: {
                return new DataBufferByte(size, numBanks);
            }
            case 1: {
                return new DataBufferUShort(size, numBanks);
            }
            case 3: {
                return new DataBufferInt(size, numBanks);
            }
        }
        throw new IllegalArgumentException("Unsupported data type: " + type);
    }

    static final class DataBufferByte
    extends MappedFileBuffer {
        private final ByteBuffer buffer;

        public DataBufferByte(int size, int numBanks) throws IOException {
            super(0, size, numBanks);
            this.buffer = (ByteBuffer)((MappedFileBuffer)this).buffer;
        }

        @Override
        public int getElem(int bank, int i) {
            return this.buffer.get(bank * this.size + i) & 0xFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            this.buffer.put(bank * this.size + i, (byte)val);
        }
    }

    static final class DataBufferUShort
    extends MappedFileBuffer {
        private final ShortBuffer buffer;

        public DataBufferUShort(int size, int numBanks) throws IOException {
            super(1, size, numBanks);
            this.buffer = (ShortBuffer)((MappedFileBuffer)this).buffer;
        }

        @Override
        public int getElem(int bank, int i) {
            return this.buffer.get(bank * this.size + i) & 0xFFFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            this.buffer.put(bank * this.size + i, (short)val);
        }
    }

    static final class DataBufferInt
    extends MappedFileBuffer {
        private final IntBuffer buffer;

        public DataBufferInt(int size, int numBanks) throws IOException {
            super(3, size, numBanks);
            this.buffer = (IntBuffer)((MappedFileBuffer)this).buffer;
        }

        @Override
        public int getElem(int bank, int i) {
            return this.buffer.get(bank * this.size + i);
        }

        @Override
        public void setElem(int bank, int i, int val) {
            this.buffer.put(bank * this.size + i, val);
        }
    }
}

