/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.mf.funksvd;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleLists;
import java.io.Serializable;

public class FeatureInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int feature;
    private final double userAverage;
    private final double itemAverage;
    private final double singularValue;
    private final DoubleList trainingErrors;

    private FeatureInfo(int f, double uavg, double iavg, double sval, DoubleList errors) {
        this.feature = f;
        this.userAverage = uavg;
        this.itemAverage = iavg;
        this.singularValue = sval;
        this.trainingErrors = new DoubleArrayList(errors);
    }

    public int getFeature() {
        return this.feature;
    }

    public int getIterCount() {
        return this.trainingErrors.size();
    }

    public DoubleList getTrainingErrors() {
        return DoubleLists.unmodifiable((DoubleList)this.trainingErrors);
    }

    public double getLastRMSE() {
        return this.trainingErrors.getDouble(this.trainingErrors.size() - 1);
    }

    public double getLastDeltaRMSE() {
        int n = this.trainingErrors.size();
        return this.trainingErrors.getDouble(n - 2) - this.trainingErrors.getDouble(n - 1);
    }

    public double getUserAverage() {
        return this.userAverage;
    }

    public double getItemAverage() {
        return this.itemAverage;
    }

    public double getSingularValue() {
        return this.singularValue;
    }

    public static class Builder
    implements org.apache.commons.lang3.builder.Builder<FeatureInfo> {
        private final int feature;
        private double userAverage;
        private double itemAverage;
        private double singularValue;
        private DoubleList trainingError = new DoubleArrayList();

        public Builder(int f) {
            this.feature = f;
        }

        public int getFeature() {
            return this.feature;
        }

        public FeatureInfo build() {
            return new FeatureInfo(this.feature, this.userAverage, this.itemAverage, this.singularValue, this.trainingError);
        }

        public double getUserAverage() {
            return this.userAverage;
        }

        public Builder setUserAverage(double userAverage) {
            this.userAverage = userAverage;
            return this;
        }

        public double getItemAverage() {
            return this.itemAverage;
        }

        public Builder setItemAverage(double itemAverage) {
            this.itemAverage = itemAverage;
            return this;
        }

        public double getSingularValue() {
            return this.singularValue;
        }

        public Builder setSingularValue(double singularValue) {
            this.singularValue = singularValue;
            return this;
        }

        public Builder addTrainingRound(double err) {
            this.trainingError.add(err);
            return this;
        }
    }
}

