/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.user;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.grouplens.lenskit.transform.threshold.Threshold;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.data.ratings.RatingVectorPDAO;
import org.lenskit.knn.user.Neighbor;
import org.lenskit.knn.user.NeighborFinder;
import org.lenskit.knn.user.UserSimilarity;
import org.lenskit.knn.user.UserSimilarityThreshold;
import org.lenskit.knn.user.UserSnapshot;
import org.lenskit.transform.normalize.UserVectorNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SnapshotNeighborFinder
implements NeighborFinder {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotNeighborFinder.class);
    private final UserSnapshot snapshot;
    private final UserSimilarity similarity;
    private final RatingVectorPDAO rvDAO;
    private final UserVectorNormalizer normalizer;
    private final Threshold threshold;

    @Inject
    public SnapshotNeighborFinder(UserSnapshot snap, UserSimilarity sim, RatingVectorPDAO rvd, UserVectorNormalizer norm, @UserSimilarityThreshold Threshold thresh) {
        this.snapshot = snap;
        this.similarity = sim;
        this.rvDAO = rvd;
        this.normalizer = norm;
        this.threshold = thresh;
    }

    @Override
    public Iterable<Neighbor> getCandidateNeighbors(final long user, LongSet items) {
        MutableSparseVector urs = MutableSparseVector.create((Map)this.rvDAO.userRatingVector(user));
        if (urs.isEmpty()) {
            return Collections.emptyList();
        }
        final ImmutableSparseVector vector = this.normalizer.normalize(user, (SparseVector)urs, null).freeze();
        LongSet qset = items;
        if (vector.size() < qset.size()) {
            qset = vector.keySet();
        }
        LongOpenHashSet candidates = new LongOpenHashSet();
        LongIterator iter = qset.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            LongSet users = this.snapshot.getItemUsers(item);
            if (users == null) continue;
            candidates.addAll((LongCollection)users);
        }
        candidates.remove(user);
        logger.debug("Found {} candidate neighbors for user {}", (Object)candidates.size(), (Object)user);
        return new Iterable<Neighbor>((LongSet)candidates){
            final /* synthetic */ LongSet val$candidates;
            {
                this.val$candidates = longSet;
            }

            @Override
            public Iterator<Neighbor> iterator() {
                return new NeighborIterator(user, (SparseVector)vector, this.val$candidates);
            }
        };
    }

    private boolean acceptSimilarity(double sim) {
        return !Double.isNaN(sim) && !Double.isInfinite(sim) && this.threshold.retain(sim);
    }

    private class NeighborIterator
    extends AbstractIterator<Neighbor> {
        private final long user;
        private final SparseVector userVector;
        private final LongIterator neighborIter;

        public NeighborIterator(long uid, SparseVector uvec, LongSet nbrs) {
            this.user = uid;
            this.userVector = uvec;
            this.neighborIter = nbrs.iterator();
        }

        protected Neighbor computeNext() {
            while (this.neighborIter.hasNext()) {
                long neighbor = this.neighborIter.nextLong();
                ImmutableSparseVector vector = SnapshotNeighborFinder.this.snapshot.getNormalizedUserVector(neighbor);
                double sim = SnapshotNeighborFinder.this.similarity.similarity(this.user, this.userVector, neighbor, (SparseVector)vector);
                if (!SnapshotNeighborFinder.this.acceptSimilarity(sim)) continue;
                return new Neighbor(neighbor, (SparseVector)SnapshotNeighborFinder.this.snapshot.getUserVector(neighbor), sim);
            }
            return (Neighbor)this.endOfData();
        }
    }
}

