/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMaps;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.grouplens.grapht.annotation.DefaultProvider;
import org.lenskit.inject.Shareable;
import org.lenskit.knn.item.model.ItemItemModel;
import org.lenskit.knn.item.model.ItemItemModelProvider;
import org.lenskit.util.collections.LongUtils;
import org.lenskit.util.keys.SortedKeyIndex;

@DefaultProvider(value=ItemItemModelProvider.class)
@Shareable
public class SimilarityMatrixModel
implements Serializable,
ItemItemModel {
    private static final long serialVersionUID = 3L;
    private final SortedKeyIndex itemDomain;
    private final ImmutableList<Long2DoubleMap> neighborhoods;
    private volatile transient String stringValue;

    @Deprecated
    public SimilarityMatrixModel(SortedKeyIndex items, List<Long2DoubleMap> nbrs) {
        this.itemDomain = items;
        this.neighborhoods = ImmutableList.copyOf(nbrs);
    }

    public SimilarityMatrixModel(Map<Long, Long2DoubleMap> nbrs) {
        this.itemDomain = SortedKeyIndex.fromCollection(nbrs.keySet());
        int n = this.itemDomain.size();
        assert (n == nbrs.size());
        ImmutableList.Builder neighbors = ImmutableList.builder();
        for (int i = 0; i < n; ++i) {
            neighbors.add((Object)LongUtils.frozenMap((Map)((Map)nbrs.get(this.itemDomain.getKey(i)))));
        }
        this.neighborhoods = neighbors.build();
    }

    @Override
    public LongSortedSet getItemUniverse() {
        return this.itemDomain.keySet();
    }

    @Override
    @Nonnull
    public Long2DoubleMap getNeighbors(long item) {
        int idx = this.itemDomain.tryGetIndex(item);
        if (idx < 0) {
            return Long2DoubleMaps.EMPTY_MAP;
        }
        return (Long2DoubleMap)this.neighborhoods.get(idx);
    }

    public String toString() {
        String val = this.stringValue;
        if (val == null) {
            int nsims = 0;
            for (Long2DoubleMap nbrs : this.neighborhoods) {
                nsims += nbrs.size();
            }
            this.stringValue = val = String.format("matrix of %d similarities for %d items", nsims, this.neighborhoods.size());
        }
        return val;
    }
}

