/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.transform.truncate.VectorTruncator;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.ItemSimilarity;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.knn.item.model.ItemItemModel;
import org.lenskit.knn.item.model.NeighborIterationStrategy;
import org.lenskit.knn.item.model.SimilarityMatrixModel;
import org.lenskit.transform.normalize.ItemVectorNormalizer;
import org.lenskit.util.collections.LongUtils;
import org.lenskit.util.keys.SortedKeyIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizingItemItemModelProvider
implements Provider<ItemItemModel> {
    private static final Logger logger = LoggerFactory.getLogger(NormalizingItemItemModelProvider.class);
    private final ItemSimilarity similarity;
    private final ItemItemBuildContext buildContext;
    private final ItemVectorNormalizer rowNormalizer;
    private final VectorTruncator truncator;
    private final NeighborIterationStrategy iterationStrategy;

    @Inject
    public NormalizingItemItemModelProvider(@Transient ItemSimilarity sim, @Transient ItemItemBuildContext context, @Transient ItemVectorNormalizer rowNorm, @Transient VectorTruncator trunc, @Transient NeighborIterationStrategy iterStrat) {
        this.similarity = sim;
        this.buildContext = context;
        this.rowNormalizer = rowNorm;
        this.truncator = trunc;
        this.iterationStrategy = iterStrat;
    }

    public SimilarityMatrixModel get() {
        logger.debug("building item-item model");
        LongSortedSet itemUniverse = this.buildContext.getItems();
        int nitems = itemUniverse.size();
        SortedKeyIndex itemDomain = SortedKeyIndex.fromCollection((Collection)itemUniverse);
        assert (itemDomain.size() == nitems);
        ArrayList matrix = Lists.newArrayListWithCapacity((int)itemDomain.size());
        MutableSparseVector currentRow = MutableSparseVector.create((Collection)itemUniverse);
        Stopwatch timer = Stopwatch.createStarted();
        for (int i = 0; i < nitems; ++i) {
            assert (matrix.size() == i);
            long rowItem = itemDomain.getKey(i);
            SparseVector vec1 = this.buildContext.itemVector(rowItem);
            LongIterator neighbors = this.iterationStrategy.neighborIterator(this.buildContext, rowItem, false);
            currentRow.fill(0.0);
            while (neighbors.hasNext()) {
                long colItem = neighbors.nextLong();
                SparseVector vec2 = this.buildContext.itemVector(colItem);
                assert (currentRow.containsKey(colItem));
                currentRow.set(colItem, this.similarity.similarity(rowItem, vec1, colItem, vec2));
            }
            currentRow.unset(rowItem);
            MutableSparseVector normalized = this.rowNormalizer.normalize(rowItem, (SparseVector)currentRow, null);
            this.truncator.truncate(normalized);
            matrix.add(LongUtils.frozenMap((Map)normalized.asMap()));
        }
        timer.stop();
        logger.info("built model for {} items in {}", (Object)nitems, (Object)timer);
        return new SimilarityMatrixModel(itemDomain, matrix);
    }

    public String toString() {
        return MoreObjects.toStringHelper(NormalizingItemItemModelProvider.class).add("similarity", (Object)this.similarity).add("normalizer", (Object)this.rowNormalizer).add("truncator", (Object)this.truncator).toString();
    }
}

