/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;
import org.lenskit.data.dao.ItemDAO;
import org.lenskit.data.dao.ItemEventDAO;
import org.lenskit.data.history.ItemEventCollection;
import org.lenskit.data.ratings.Rating;
import org.lenskit.data.ratings.Ratings;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.transform.normalize.ItemVectorNormalizer;
import org.lenskit.util.collections.LongUtils;
import org.lenskit.util.io.ObjectStream;
import org.lenskit.util.keys.SortedKeyIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemwiseBuildContextProvider
implements Provider<ItemItemBuildContext> {
    private static final Logger logger = LoggerFactory.getLogger(ItemwiseBuildContextProvider.class);
    private final ItemEventDAO itemEventDAO;
    private final ItemDAO itemDAO;
    private final ItemVectorNormalizer normalizer;

    @Inject
    public ItemwiseBuildContextProvider(@Transient ItemEventDAO edao, @Transient ItemDAO idao, @Transient ItemVectorNormalizer norm) {
        this.itemEventDAO = edao;
        this.itemDAO = idao;
        this.normalizer = norm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemItemBuildContext get() {
        logger.info("constructing build context");
        Stopwatch timer = Stopwatch.createStarted();
        logger.debug("using normalizer {}", (Object)this.normalizer);
        logger.debug("Building item data");
        Long2ObjectOpenHashMap userItems = new Long2ObjectOpenHashMap(1000);
        Long2ObjectOpenHashMap itemVectors = new Long2ObjectOpenHashMap(1000);
        try (ObjectStream itemObjectStream = this.itemEventDAO.streamEventsByItem();){
            for (ItemEventCollection item : itemObjectStream) {
                if (logger.isTraceEnabled()) {
                    logger.trace("processing {} ratings for item {}", (Object)item.size(), (Object)item);
                }
                ImmutableList ratings = FluentIterable.from((Iterable)item).filter(Rating.class).toList();
                MutableSparseVector vector = MutableSparseVector.create((Map)Ratings.itemRatingVector((Collection)ratings));
                this.normalizer.normalize(item.getItemId(), (SparseVector)vector, vector);
                for (VectorEntry e : vector) {
                    long user = e.getKey();
                    LongList uis = (LongList)userItems.get(user);
                    if (uis == null) {
                        uis = new LongArrayList();
                        userItems.put(user, (Object)uis);
                    }
                    uis.add(item.getItemId());
                }
                itemVectors.put(item.getItemId(), (Object)vector.freeze());
            }
        }
        Long2ObjectOpenHashMap userItemSets = new Long2ObjectOpenHashMap();
        for (Long2ObjectMap.Entry entry : userItems.long2ObjectEntrySet()) {
            userItemSets.put(entry.getLongKey(), (Object)LongUtils.packedSet((Collection)((Collection)entry.getValue())));
        }
        SortedKeyIndex items = SortedKeyIndex.fromCollection((Collection)itemVectors.keySet());
        SparseVector[] itemData = new SparseVector[items.size()];
        for (int i = 0; i < itemData.length; ++i) {
            long itemId = items.getKey(i);
            itemData[i] = (SparseVector)itemVectors.get(itemId);
        }
        timer.stop();
        logger.info("finished build context for {} items in {}", (Object)items.size(), (Object)timer);
        return new ItemItemBuildContext(items, itemData, (Long2ObjectMap<LongSortedSet>)userItemSets);
    }
}

