/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import javax.inject.Provider;
import org.grouplens.lenskit.transform.threshold.Threshold;
import org.grouplens.lenskit.vectors.SparseVector;
import org.lenskit.inject.Transient;
import org.lenskit.knn.item.ItemSimilarity;
import org.lenskit.knn.item.ItemSimilarityThreshold;
import org.lenskit.knn.item.MinCommonUsers;
import org.lenskit.knn.item.ModelSize;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.lenskit.knn.item.model.ItemItemModel;
import org.lenskit.knn.item.model.NeighborIterationStrategy;
import org.lenskit.knn.item.model.SimilarityMatrixModel;
import org.lenskit.util.ProgressLogger;
import org.lenskit.util.ScoredIdAccumulator;
import org.lenskit.util.TopNScoredIdAccumulator;
import org.lenskit.util.UnlimitedScoredIdAccumulator;
import org.lenskit.util.collections.LongUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ItemItemModelProvider
implements Provider<ItemItemModel> {
    private static final Logger logger = LoggerFactory.getLogger(ItemItemModelProvider.class);
    private final ItemSimilarity itemSimilarity;
    private final ItemItemBuildContext buildContext;
    private final Threshold threshold;
    private final NeighborIterationStrategy neighborStrategy;
    private final int minCommonUsers;
    private final int modelSize;

    @Inject
    public ItemItemModelProvider(@Transient ItemSimilarity similarity, @Transient ItemItemBuildContext context, @Transient @ItemSimilarityThreshold Threshold thresh, @Transient NeighborIterationStrategy nbrStrat, @MinCommonUsers int minCU, @ModelSize int size) {
        this.itemSimilarity = similarity;
        this.buildContext = context;
        this.threshold = thresh;
        this.neighborStrategy = nbrStrat;
        this.minCommonUsers = minCU;
        this.modelSize = size;
    }

    public SimilarityMatrixModel get() {
        logger.info("building item-item model for {} items", (Object)this.buildContext.getItems().size());
        logger.debug("using similarity function {}", (Object)this.itemSimilarity);
        logger.debug("similarity function is {}", (Object)(this.itemSimilarity.isSparse() ? "sparse" : "non-sparse"));
        logger.debug("similarity function is {}", (Object)(this.itemSimilarity.isSymmetric() ? "symmetric" : "non-symmetric"));
        LongSortedSet allItems = this.buildContext.getItems();
        Long2ObjectMap<ScoredIdAccumulator> rows = this.makeAccumulators((LongSet)allItems);
        int nitems = allItems.size();
        LongBidirectionalIterator outer = allItems.iterator();
        ProgressLogger progress = ProgressLogger.create((Logger)logger).setCount(nitems).setLabel("item-item model build").setWindow(50).start();
        int ndone = 0;
        int npairs = 0;
        while (outer.hasNext()) {
            SparseVector vec1;
            ++ndone;
            long itemId1 = outer.nextLong();
            if (logger.isTraceEnabled()) {
                logger.trace("computing similarities for item {} ({} of {})", new Object[]{itemId1, ndone, nitems});
            }
            if ((vec1 = this.buildContext.itemVector(itemId1)).size() < this.minCommonUsers) {
                if (logger.isTraceEnabled()) {
                    logger.trace("item {} has {} (< {}) users, skipping", new Object[]{itemId1, vec1.size(), this.minCommonUsers});
                }
                progress.advance();
                continue;
            }
            LongIterator itemIter = this.neighborStrategy.neighborIterator(this.buildContext, itemId1, this.itemSimilarity.isSymmetric());
            ScoredIdAccumulator row = (ScoredIdAccumulator)rows.get(itemId1);
            while (itemIter.hasNext()) {
                double sim;
                long itemId2 = itemIter.nextLong();
                if (itemId1 == itemId2) continue;
                SparseVector vec2 = this.buildContext.itemVector(itemId2);
                if (!LongUtils.hasNCommonItems((LongSortedSet)vec1.keySet(), (LongSortedSet)vec2.keySet(), (int)this.minCommonUsers) || !this.threshold.retain(sim = this.itemSimilarity.similarity(itemId1, vec1, itemId2, vec2))) continue;
                row.put(itemId2, sim);
                ++npairs;
                if (!this.itemSimilarity.isSymmetric()) continue;
                ((ScoredIdAccumulator)rows.get(itemId2)).put(itemId1, sim);
                ++npairs;
            }
            progress.advance();
        }
        progress.finish();
        logger.info("built model of {} similarities for {} items in {}", new Object[]{npairs, ndone, progress.elapsedTime()});
        return new SimilarityMatrixModel((Map<Long, Long2DoubleMap>)this.finishRows(rows));
    }

    private Long2ObjectMap<ScoredIdAccumulator> makeAccumulators(LongSet items) {
        Long2ObjectOpenHashMap rows = new Long2ObjectOpenHashMap(items.size());
        LongIterator iter = items.iterator();
        while (iter.hasNext()) {
            long item = iter.nextLong();
            Object accum = this.modelSize == 0 ? new UnlimitedScoredIdAccumulator() : new TopNScoredIdAccumulator(this.modelSize);
            rows.put(item, accum);
        }
        return rows;
    }

    private Long2ObjectMap<Long2DoubleMap> finishRows(Long2ObjectMap<ScoredIdAccumulator> rows) {
        Long2ObjectOpenHashMap results = new Long2ObjectOpenHashMap(rows.size());
        for (Long2ObjectMap.Entry e : rows.long2ObjectEntrySet()) {
            results.put(e.getLongKey(), (Object)((ScoredIdAccumulator)e.getValue()).finishMap());
        }
        return results;
    }
}

