/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item.model;

import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.NoSuchElementException;
import org.lenskit.knn.item.model.ItemItemBuildContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdaptiveSparseItemIterator
extends AbstractLongIterator {
    private static final Logger logger = LoggerFactory.getLogger(AdaptiveSparseItemIterator.class);
    private final ItemItemBuildContext context;
    private final LongSet users;
    private final long lowerBound;
    private final int universeSize;
    private LongSet seen;
    private boolean advanced;
    private boolean atEnd;
    private long nextItem;
    private LongIterator userIter;
    private LongIterator currentItems;
    private int usersSeen;

    public AdaptiveSparseItemIterator(ItemItemBuildContext context, LongSet users) {
        this(context, users, Long.MIN_VALUE);
    }

    public AdaptiveSparseItemIterator(ItemItemBuildContext context, LongSet users, long lowerBound) {
        this.context = context;
        this.users = users;
        this.lowerBound = lowerBound;
        this.universeSize = lowerBound == Long.MIN_VALUE ? context.getItems().size() : context.getItems().tailSet(lowerBound).size();
        this.seen = new LongOpenHashSet(context.getItems().size());
        this.userIter = users.iterator();
    }

    private void maybeAdvance() {
        if (this.advanced) {
            return;
        }
        while (!this.advanced) {
            if (this.currentItems == null && this.userIter != null) {
                LongSortedSet items = null;
                if (this.universeSize - this.seen.size() <= this.universeSize / 4 && this.usersSeen <= this.users.size() / 2) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("dropping sparsity, using full universe (saw {} of {} items, {} of {} users)", new Object[]{this.seen.size(), this.universeSize, this.usersSeen, this.users.size()});
                    }
                    items = this.context.getItems();
                    this.userIter = null;
                } else if (this.userIter.hasNext()) {
                    long user = this.userIter.nextLong();
                    ++this.usersSeen;
                    items = this.context.getUserItems(user);
                }
                if (items != null) {
                    this.currentItems = this.lowerBound == Long.MIN_VALUE ? items.iterator() : items.iterator(this.lowerBound);
                }
            }
            if (this.currentItems == null) {
                this.advanced = true;
                this.atEnd = true;
                continue;
            }
            if (this.currentItems.hasNext()) {
                this.nextItem = this.currentItems.nextLong();
                if (this.seen.contains(this.nextItem)) continue;
                this.advanced = true;
                this.seen.add(this.nextItem);
                continue;
            }
            this.currentItems = null;
        }
    }

    public boolean hasNext() {
        this.maybeAdvance();
        return !this.atEnd;
    }

    public long nextLong() {
        this.maybeAdvance();
        if (this.atEnd) {
            throw new NoSuchElementException();
        }
        this.advanced = false;
        return this.nextItem;
    }
}

