/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import java.io.Serializable;
import org.grouplens.lenskit.symbols.Symbol;
import org.lenskit.inject.Shareable;
import org.lenskit.knn.item.ItemItemScoreAccumulator;
import org.lenskit.knn.item.NeighborhoodScorer;
import org.lenskit.util.math.Vectors;

@Shareable
public class WeightedAverageNeighborhoodScorer
implements NeighborhoodScorer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Symbol NEIGHBORHOOD_WEIGHT_SYMBOL = Symbol.of((String)"org.grouplens.lenskit.knn.item.neighborhoodWeight");

    @Override
    public void score(long item, Long2DoubleMap neighbors, Long2DoubleMap scores, ItemItemScoreAccumulator accum) {
        double weight = Vectors.sumAbs((Long2DoubleMap)neighbors);
        if (weight > 0.0) {
            double weightedSum = Vectors.dotProduct((Long2DoubleMap)neighbors, (Long2DoubleMap)scores);
            accum.add(item, weightedSum / weight, neighbors.size(), weight);
        }
    }

    public String toString() {
        return "[NeighborhoodScorer: WeightedAverage]";
    }
}

