/*
 * Decompiled with CFR 0.152.
 */
package org.lenskit.knn.item;

import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.lenskit.api.ResultMap;
import org.lenskit.basic.AbstractItemBasedItemScorer;
import org.lenskit.knn.NeighborhoodSize;
import org.lenskit.knn.item.ItemItemResult;
import org.lenskit.knn.item.ItemItemScoreAccumulator;
import org.lenskit.knn.item.NeighborhoodScorer;
import org.lenskit.knn.item.SimilaritySumNeighborhoodScorer;
import org.lenskit.knn.item.model.ItemItemModel;
import org.lenskit.results.Results;
import org.lenskit.util.TopNScoredIdAccumulator;
import org.lenskit.util.UnlimitedScoredIdAccumulator;
import org.lenskit.util.collections.LongUtils;

public class ItemItemItemBasedItemScorer
extends AbstractItemBasedItemScorer {
    protected final ItemItemModel model;
    @Nonnull
    protected final NeighborhoodScorer scorer;
    private final int neighborhoodSize;

    @Inject
    public ItemItemItemBasedItemScorer(ItemItemModel m, @NeighborhoodSize int nnbrs) {
        this.model = m;
        this.scorer = new SimilaritySumNeighborhoodScorer();
        this.neighborhoodSize = nnbrs;
    }

    @Nonnull
    public Map<Long, Double> scoreRelatedItems(@Nonnull Collection<Long> basket, @Nonnull Collection<Long> items) {
        Long2DoubleOpenHashMap results = new Long2DoubleOpenHashMap();
        ItemItemScoreAccumulator accum = ItemItemScoreAccumulator.basic((Long2DoubleMap)results);
        this.scoreItems(basket, items, accum);
        return results;
    }

    public ResultMap scoreRelatedItemsWithDetails(@Nonnull Collection<Long> basket, Collection<Long> items) {
        ArrayList<ItemItemResult> results = new ArrayList<ItemItemResult>();
        ItemItemScoreAccumulator accum = ItemItemScoreAccumulator.detailed(results);
        this.scoreItems(basket, items, accum);
        return Results.newResultMap(results);
    }

    private void scoreItems(@Nonnull Collection<Long> basket, Collection<Long> items, ItemItemScoreAccumulator accum) {
        LongSortedSet bset = LongUtils.packedSet(basket);
        Long2DoubleMap basketScores = LongUtils.constantDoubleMap((Set)bset, (double)1.0);
        LongIterator iter = LongIterators.asLongIterator(items.iterator());
        while (iter.hasNext()) {
            long item = iter.nextLong();
            this.scoreItem(basketScores, item, accum);
        }
    }

    protected void scoreItem(Long2DoubleMap scores, long item, ItemItemScoreAccumulator accum) {
        Long2DoubleMap allNeighbors = this.model.getNeighbors(item);
        Object acc = this.neighborhoodSize > 0 ? new TopNScoredIdAccumulator(this.neighborhoodSize) : new UnlimitedScoredIdAccumulator();
        for (Long2DoubleMap.Entry nbr : allNeighbors.long2DoubleEntrySet()) {
            if (!scores.containsKey(nbr.getLongKey())) continue;
            acc.put(nbr.getLongKey(), nbr.getDoubleValue());
        }
        Long2DoubleMap neighborhood = acc.finishMap();
        this.scorer.score(item, neighborhood, scores, accum);
    }
}

