/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import org.legendofdragoon.scripting.MathHelper;

public class State {
    private final byte[] script;
    private int headerOffset;
    private int currentOffset;

    public State(byte[] script) {
        this.script = script;
    }

    public int length() {
        return this.script.length;
    }

    public void step() {
        this.headerOffset = this.currentOffset;
    }

    public int headerOffset() {
        return this.headerOffset;
    }

    public void headerOffset(int opOffset) {
        this.headerOffset = opOffset;
    }

    public int currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    public int currentWord() {
        return this.wordAt(this.currentOffset);
    }

    public int wordAt(int index) {
        return MathHelper.get(this.script, index, 4);
    }

    public int paramType() {
        return this.script[this.currentOffset + 3] & 0xFF;
    }

    public int param0() {
        return this.script[this.currentOffset] & 0xFF;
    }

    public int param1() {
        return this.script[this.currentOffset + 1] & 0xFF;
    }

    public int param2() {
        return this.script[this.currentOffset + 2] & 0xFF;
    }

    public State advance() {
        return this.advance(1);
    }

    public State advance(int words) {
        this.currentOffset += words * 4;
        return this;
    }

    public State jump(int index) {
        this.currentOffset = index;
        return this;
    }

    public boolean hasMore() {
        return this.currentOffset / 4 < this.script.length / 4;
    }
}

