/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

public final class MathHelper {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    private static final float PSX_DEG_TO_DEG = 0.087890625f;
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float PSX_DEG_TO_RAD = 0.0015339808f;
    private static final float DEG_TO_PSX_DEG = 11.377778f;
    private static final float RAD_TO_DEG = 57.29578f;
    private static final float RAD_TO_PSX_DEG = 651.8987f;

    private MathHelper() {
    }

    public static int get(byte[] data, int offset, int size) {
        int value = 0;
        for (int i = 0; i < size; ++i) {
            value |= (data[offset + i] & 0xFF) << i * 8;
        }
        return value;
    }

    public static float psxDegToRad(int psxDeg) {
        return (float)psxDeg * 0.0015339808f;
    }

    public static int radToPsxDeg(float rads) {
        return (int)(rads * 651.8987f);
    }

    public static float atan2(float y, float x) {
        if (y == 0.0f && x == 0.0f) {
            return 0.0f;
        }
        if (MathHelper.flEq(y, -0.0f)) {
            y = 0.0f;
        }
        return (float)Math.atan2(y, x);
    }

    public static boolean flEq(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static boolean flEq(float a, float b) {
        return MathHelper.flEq(a, b, 1.0E-5f);
    }

    public static int safeDiv(int num, int div) {
        if (div == 0) {
            return Integer.compare(0, num);
        }
        return num / div;
    }
}

