/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting.tokens;

import java.util.ArrayList;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.legendofdragoon.scripting.Lexer;
import org.legendofdragoon.scripting.tokens.Entry;

public class LodString
extends Entry {
    private static final Logger LOGGER = LogManager.getFormatterLogger();
    public final int[] chars;

    public LodString(int address, int[] chars) {
        super(address);
        this.chars = chars;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int chr : this.chars) {
            CONTROLS control;
            if ((chr & 0xFF00) != 0 && (control = CONTROLS.fromControl(chr)) != null) {
                out.append('<').append(control.name);
                if (control.hasParam) {
                    out.append('=').append(chr & 0xFF);
                }
                out.append('>');
                continue;
            }
            out.append(switch (chr) {
                case 0 -> Character.valueOf(' ');
                case 1 -> Character.valueOf(',');
                case 2 -> Character.valueOf('.');
                case 3 -> Character.valueOf('\u00b7');
                case 4 -> Character.valueOf(':');
                case 5 -> Character.valueOf('?');
                case 6 -> Character.valueOf('!');
                case 7 -> Character.valueOf('_');
                case 8 -> Character.valueOf('/');
                case 9 -> Character.valueOf('\'');
                case 10 -> Character.valueOf('\"');
                case 11 -> Character.valueOf('(');
                case 12 -> Character.valueOf(')');
                case 13 -> Character.valueOf('-');
                case 14 -> Character.valueOf('`');
                case 15 -> Character.valueOf('%');
                case 16 -> Character.valueOf('&');
                case 17 -> Character.valueOf('*');
                case 18 -> Character.valueOf('@');
                case 19 -> Character.valueOf('+');
                case 20 -> Character.valueOf('~');
                case 21 -> Character.valueOf('0');
                case 22 -> Character.valueOf('1');
                case 23 -> Character.valueOf('2');
                case 24 -> Character.valueOf('3');
                case 25 -> Character.valueOf('4');
                case 26 -> Character.valueOf('5');
                case 27 -> Character.valueOf('6');
                case 28 -> Character.valueOf('7');
                case 29 -> Character.valueOf('8');
                case 30 -> Character.valueOf('9');
                case 31 -> Character.valueOf('A');
                case 32 -> Character.valueOf('B');
                case 33 -> Character.valueOf('C');
                case 34 -> Character.valueOf('D');
                case 35 -> Character.valueOf('E');
                case 36 -> Character.valueOf('F');
                case 37 -> Character.valueOf('G');
                case 38 -> Character.valueOf('H');
                case 39 -> Character.valueOf('I');
                case 40 -> Character.valueOf('J');
                case 41 -> Character.valueOf('K');
                case 42 -> Character.valueOf('L');
                case 43 -> Character.valueOf('M');
                case 44 -> Character.valueOf('N');
                case 45 -> Character.valueOf('O');
                case 46 -> Character.valueOf('P');
                case 47 -> Character.valueOf('Q');
                case 48 -> Character.valueOf('R');
                case 49 -> Character.valueOf('S');
                case 50 -> Character.valueOf('T');
                case 51 -> Character.valueOf('U');
                case 52 -> Character.valueOf('V');
                case 53 -> Character.valueOf('W');
                case 54 -> Character.valueOf('X');
                case 55 -> Character.valueOf('Y');
                case 56 -> Character.valueOf('Z');
                case 57 -> Character.valueOf('a');
                case 58 -> Character.valueOf('b');
                case 59 -> Character.valueOf('c');
                case 60 -> Character.valueOf('d');
                case 61 -> Character.valueOf('e');
                case 62 -> Character.valueOf('f');
                case 63 -> Character.valueOf('g');
                case 64 -> Character.valueOf('h');
                case 65 -> Character.valueOf('i');
                case 66 -> Character.valueOf('j');
                case 67 -> Character.valueOf('k');
                case 68 -> Character.valueOf('l');
                case 69 -> Character.valueOf('m');
                case 70 -> Character.valueOf('n');
                case 71 -> Character.valueOf('o');
                case 72 -> Character.valueOf('p');
                case 73 -> Character.valueOf('q');
                case 74 -> Character.valueOf('r');
                case 75 -> Character.valueOf('s');
                case 76 -> Character.valueOf('t');
                case 77 -> Character.valueOf('u');
                case 78 -> Character.valueOf('v');
                case 79 -> Character.valueOf('w');
                case 80 -> Character.valueOf('x');
                case 81 -> Character.valueOf('y');
                case 82 -> Character.valueOf('z');
                case 83 -> Character.valueOf('[');
                case 84 -> Character.valueOf(']');
                case 85 -> Character.valueOf(';');
                default -> {
                    LOGGER.warn("Found invalid character %x", (Object)chr);
                    yield "<chr=0x%x>".formatted(chr);
                }
            });
        }
        return out.toString();
    }

    public static LodString fromString(int address, String string) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        boolean noTerm = false;
        for (int i = 0; i < string.length(); ++i) {
            char chr = string.charAt(i);
            if (chr == '<') {
                int end = string.indexOf(62, i + 1);
                String controlString = string.substring(i, end + 1);
                Matcher controlMatcher = Lexer.CONTROL_PATTERN.matcher(controlString);
                if (controlMatcher.matches()) {
                    String controlName = controlMatcher.group(1).toLowerCase();
                    if ("noterm".equalsIgnoreCase(controlName)) {
                        noTerm = true;
                        i += 7;
                        continue;
                    }
                    String paramString = controlMatcher.group(2);
                    CONTROLS control = CONTROLS.fromName(controlName);
                    int converted = control.control;
                    if (control.hasParam) {
                        converted |= LodString.parseInt(paramString);
                    }
                    out.add(converted);
                }
                i = end;
                continue;
            }
            out.add(switch (chr) {
                case ' ' -> 0;
                case ',' -> 1;
                case '.' -> 2;
                case '\u00b7' -> 3;
                case ':' -> 4;
                case '?' -> 5;
                case '!' -> 6;
                case '_' -> 7;
                case '/' -> 8;
                case '\'' -> 9;
                case '\"' -> 10;
                case '(' -> 11;
                case ')' -> 12;
                case '-' -> 13;
                case '`' -> 14;
                case '%' -> 15;
                case '&' -> 16;
                case '*' -> 17;
                case '@' -> 18;
                case '+' -> 19;
                case '~' -> 20;
                case '0' -> 21;
                case '1' -> 22;
                case '2' -> 23;
                case '3' -> 24;
                case '4' -> 25;
                case '5' -> 26;
                case '6' -> 27;
                case '7' -> 28;
                case '8' -> 29;
                case '9' -> 30;
                case 'A' -> 31;
                case 'B' -> 32;
                case 'C' -> 33;
                case 'D' -> 34;
                case 'E' -> 35;
                case 'F' -> 36;
                case 'G' -> 37;
                case 'H' -> 38;
                case 'I' -> 39;
                case 'J' -> 40;
                case 'K' -> 41;
                case 'L' -> 42;
                case 'M' -> 43;
                case 'N' -> 44;
                case 'O' -> 45;
                case 'P' -> 46;
                case 'Q' -> 47;
                case 'R' -> 48;
                case 'S' -> 49;
                case 'T' -> 50;
                case 'U' -> 51;
                case 'V' -> 52;
                case 'W' -> 53;
                case 'X' -> 54;
                case 'Y' -> 55;
                case 'Z' -> 56;
                case 'a' -> 57;
                case 'b' -> 58;
                case 'c' -> 59;
                case 'd' -> 60;
                case 'e' -> 61;
                case 'f' -> 62;
                case 'g' -> 63;
                case 'h' -> 64;
                case 'i' -> 65;
                case 'j' -> 66;
                case 'k' -> 67;
                case 'l' -> 68;
                case 'm' -> 69;
                case 'n' -> 70;
                case 'o' -> 71;
                case 'p' -> 72;
                case 'q' -> 73;
                case 'r' -> 74;
                case 's' -> 75;
                case 't' -> 76;
                case 'u' -> 77;
                case 'v' -> 78;
                case 'w' -> 79;
                case 'x' -> 80;
                case 'y' -> 81;
                case 'z' -> 82;
                case '[' -> 83;
                case ']' -> 84;
                case ';' -> 85;
                default -> throw new RuntimeException("Illegal char %c".formatted(Character.valueOf(chr)));
            });
        }
        if (!noTerm) {
            out.add(41215);
        }
        return new LodString(address, out.stream().mapToInt(Integer::intValue).toArray());
    }

    private static int parseInt(String val) {
        if (Lexer.NUMBER_PATTERN.matcher(val).matches()) {
            if (val.startsWith("0x")) {
                return Integer.parseUnsignedInt(val.substring(2), 16);
            }
            return Integer.parseInt(val);
        }
        throw new NumberFormatException("Invalid number " + val);
    }

    private static enum CONTROLS {
        LINE("line", 41471, false),
        BUTTON("button", 41472, false),
        MULTIBOX("multibox", 41983, false),
        SPEED("speed", 42240, true),
        PAUSE("pause", 42496, true),
        COLOUR("colour", 42752, true),
        VAR("var", 43008, true),
        XOFFSET("xoffset", 44288, true),
        YOFFSET("yoffset", 44544, true),
        SAUTO("sauto", 45056, true),
        ELEMENT("element", 45312, true),
        ARROW("arrow", 45568, true),
        INVALID("chr", 0, true);

        public final String name;
        public final int control;
        public final boolean hasParam;

        public static CONTROLS fromControl(int control) {
            for (CONTROLS c : CONTROLS.values()) {
                if (!(c.hasParam ? (c.control & 0xFF00) == (control & 0xFF00) : c.control == control)) continue;
                return c;
            }
            return null;
        }

        public static CONTROLS fromName(String name) {
            for (CONTROLS c : CONTROLS.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            throw new RuntimeException("Unknown control %s".formatted(name));
        }

        private CONTROLS(String name, int control, boolean hasParam) {
            this.name = name;
            this.control = control;
            this.hasParam = hasParam;
        }
    }
}

