/*
 * Decompiled with CFR 0.152.
 */
package org.legendofdragoon.scripting;

import com.github.difflib.patch.PatchFailedException;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.legendofdragoon.scripting.Compiler;
import org.legendofdragoon.scripting.Disassembler;
import org.legendofdragoon.scripting.Lexer;
import org.legendofdragoon.scripting.Patcher;
import org.legendofdragoon.scripting.Translator;
import org.legendofdragoon.scripting.meta.Meta;
import org.legendofdragoon.scripting.meta.MetaManager;
import org.legendofdragoon.scripting.meta.NoSuchVersionException;
import org.legendofdragoon.scripting.tokens.Script;

public final class Shell {
    private static final Logger LOGGER;

    private Shell() {
    }

    public static void main(String[] args) throws IOException, URISyntaxException, CsvException, NoSuchVersionException, PatchFailedException {
        CommandLine cmd;
        if (args.length == 0) {
            LOGGER.info("Commands: [v]ersions, [d]ecompile, [c]ompile, [g]enpatch, [a]pplypatch, [u]ndopatch");
            System.exit(1);
            return;
        }
        Path cacheDir = Path.of("./cache", new String[0]);
        MetaManager metaManager = new MetaManager(new URI("https://legendofdragoon.org/scmeta/"), cacheDir);
        if ("v".equals(args[0]) || "versions".equals(args[0])) {
            LOGGER.info("Fetching...");
            String[] versions = metaManager.getVersions();
            LOGGER.info("Versions:");
            for (String version : versions) {
                LOGGER.info(version);
            }
            System.exit(0);
            return;
        }
        if ("g".equals(args[0]) || "genpatch".equals(args[0])) {
            Shell.generateDiff(args);
            System.exit(0);
            return;
        }
        if ("a".equals(args[0]) || "applypatch".equals(args[0])) {
            Shell.applyDiff(args);
            System.exit(0);
            return;
        }
        if ("u".equals(args[0]) || "undopatch".equals(args[0])) {
            Shell.undoDiff(args);
            System.exit(0);
            return;
        }
        Options options = new Options();
        options.addOption("v", "version", true, "The meta version to use");
        options.addRequiredOption("i", "in", true, "The input file");
        options.addRequiredOption("o", "out", true, "The output file");
        if ("d".equals(args[0]) || "decompile".equals(args[0])) {
            options.addOption("b", "branch", true, "Force the decompiler to decompile this branch");
        }
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
            helper.printHelp("Usage:", options);
            System.exit(1);
            return;
        }
        String version = cmd.getOptionValue("version", "snapshot");
        LOGGER.info("Loading meta %s...", (Object)version);
        Meta meta = metaManager.loadMeta(version);
        Path inputFile = Paths.get(cmd.getOptionValue("in"), new String[0]).toAbsolutePath();
        Path outputFile = Paths.get(cmd.getOptionValue("out"), new String[0]).toAbsolutePath();
        if (!Files.exists(inputFile, new LinkOption[0])) {
            LOGGER.error("Error: input file does not exist");
            System.exit(1);
            return;
        }
        switch (args[0]) {
            case "d": 
            case "decompile": {
                int[] branches;
                String[] branchesIn = cmd.getOptionValues("branch");
                if (branchesIn == null) {
                    branches = new int[]{};
                } else {
                    branches = new int[branchesIn.length];
                    for (int i = 0; i < branchesIn.length; ++i) {
                        branches[i] = Integer.parseInt(branchesIn[i], 16);
                    }
                }
                LOGGER.info("Decompiling %s...", (Object)inputFile);
                Disassembler disassembler = new Disassembler(meta);
                Translator translator = new Translator();
                byte[] bytes = Files.readAllBytes(inputFile);
                Script script = disassembler.disassemble(bytes, branches);
                String decompiledOutput = translator.translate(script, meta);
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                Files.writeString(outputFile, (CharSequence)decompiledOutput, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            case "c": 
            case "compile": {
                LOGGER.info("Compiling... %s", (Object)inputFile);
                Compiler compiler = new Compiler();
                Lexer lexer = new Lexer(meta);
                String input = Files.readString(inputFile);
                Script lexedDecompiledSource = lexer.lex(input);
                int[] recompiledSource = compiler.compile(lexedDecompiledSource);
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                Files.write(outputFile, Shell.intsToBytes(recompiledSource), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            default: {
                LOGGER.info("Commands: [v]ersions, [d]ecompile, [c]ompile, [g]enpatch, [a]pplypatch, [u]ndopatch");
                System.exit(1);
            }
        }
    }

    private static void generateDiff(String[] args) throws IOException {
        CommandLine cmd;
        Options options = new Options();
        options.addRequiredOption("a", "original", true, "The original file");
        options.addRequiredOption("b", "modified", true, "The modified file");
        options.addRequiredOption("o", "out", true, "The output file");
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
            helper.printHelp("Usage:", options);
            System.exit(1);
            return;
        }
        Path originalFile = Paths.get(cmd.getOptionValue("original"), new String[0]).toAbsolutePath();
        Path modifiedFile = Paths.get(cmd.getOptionValue("modified"), new String[0]).toAbsolutePath();
        Path outputFile = Paths.get(cmd.getOptionValue("out"), new String[0]).toAbsolutePath();
        if (!Files.exists(originalFile, new LinkOption[0]) || !Files.exists(modifiedFile, new LinkOption[0])) {
            LOGGER.error("Error: one or both input files do not exist");
            System.exit(1);
            return;
        }
        LOGGER.info("Generating diff...");
        LOGGER.info("Original: %s", (Object)originalFile);
        LOGGER.info("Modified: %s", (Object)modifiedFile);
        LOGGER.info("Output: %s", (Object)outputFile);
        String output = Patcher.generatePatch(originalFile, modifiedFile);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.writeString(outputFile, (CharSequence)output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void applyDiff(String[] args) throws IOException, PatchFailedException {
        CommandLine cmd;
        Options options = new Options();
        options.addRequiredOption("a", "original", true, "The original file");
        options.addRequiredOption("b", "patch", true, "The patch file");
        options.addRequiredOption("o", "out", true, "The output file");
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
            helper.printHelp("Usage:", options);
            System.exit(1);
            return;
        }
        Path originalFile = Paths.get(cmd.getOptionValue("original"), new String[0]).toAbsolutePath();
        Path patchFile = Paths.get(cmd.getOptionValue("patch"), new String[0]).toAbsolutePath();
        Path outputFile = Paths.get(cmd.getOptionValue("out"), new String[0]).toAbsolutePath();
        if (!Files.exists(originalFile, new LinkOption[0]) || !Files.exists(patchFile, new LinkOption[0])) {
            LOGGER.error("Error: one or both input files do not exist");
            System.exit(1);
            return;
        }
        LOGGER.info("Applying diff...");
        LOGGER.info("Original: %s", (Object)originalFile);
        LOGGER.info("Patch: %s", (Object)patchFile);
        LOGGER.info("Output: %s", (Object)outputFile);
        String output = Patcher.applyPatch(originalFile, patchFile);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.writeString(outputFile, (CharSequence)output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static void undoDiff(String[] args) throws IOException, PatchFailedException {
        CommandLine cmd;
        Options options = new Options();
        options.addRequiredOption("a", "patched", true, "The patched file");
        options.addRequiredOption("b", "patch", true, "The patch file");
        options.addRequiredOption("o", "out", true, "The output file");
        DefaultParser parser = new DefaultParser();
        HelpFormatter helper = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage());
            helper.printHelp("Usage:", options);
            System.exit(1);
            return;
        }
        Path patchedFile = Paths.get(cmd.getOptionValue("patched"), new String[0]).toAbsolutePath();
        Path patchFile = Paths.get(cmd.getOptionValue("patch"), new String[0]).toAbsolutePath();
        Path outputFile = Paths.get(cmd.getOptionValue("out"), new String[0]).toAbsolutePath();
        if (!Files.exists(patchedFile, new LinkOption[0]) || !Files.exists(patchFile, new LinkOption[0])) {
            LOGGER.error("Error: one or both input files do not exist");
            System.exit(1);
            return;
        }
        LOGGER.info("Applying diff...");
        LOGGER.info("Patched: %s", (Object)patchedFile);
        LOGGER.info("Patch: %s", (Object)patchFile);
        LOGGER.info("Output: %s", (Object)outputFile);
        String output = Patcher.undoPatch(patchedFile, patchFile);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.writeString(outputFile, (CharSequence)output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static byte[] intsToBytes(int[] ints) {
        ByteBuffer buffer = ByteBuffer.allocate(ints.length * 4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.asIntBuffer().put(ints);
        return buffer.array();
    }

    static {
        System.setProperty("log4j.skipJansi", "false");
        PluginManager.addPackage((String)"org.legendofdragoon");
        LOGGER = LogManager.getFormatterLogger();
    }
}

